/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import java.util.Vector;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.pdu.GetPdu_vec;
import uk.co.westhawk.snmp.pdu.OneGetBulkPdu;
import uk.co.westhawk.snmp.pdu.SetPdu_vec;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class BlockPdu {
    private static final String version_id = "@(#)$Id: BlockPdu.java,v 3.11 2002/10/23 09:56:20 birgit Exp $ Copyright Westhawk Ltd";
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int GETNEXT = 2;
    public static final int GETBULK = 3;
    protected Vector reqVarbinds;
    private SnmpContextBasisFace context;
    private Pdu pdu;
    private int type = 0;
    private int non_rep = 0;
    private int max_rep = 0;
    private int[] retry_intervals = null;

    public BlockPdu(SnmpContextBasisFace con) {
        this.context = con;
        this.reqVarbinds = new Vector(1, 1);
    }

    public void addOid(String oid) {
        varbind vb = new varbind(oid);
        this.addOid(vb);
    }

    public void addOid(String oid, AsnObject val) {
        varbind vb = new varbind(oid, val);
        this.addOid(vb);
    }

    public void addOid(AsnObjectId oid, AsnObject val) {
        varbind vb = new varbind(oid, val);
        this.addOid(vb);
    }

    public void addOid(AsnObjectId oid) {
        varbind vb = new varbind(oid);
        this.addOid(vb);
    }

    public void addOid(varbind var) {
        this.reqVarbinds.addElement(var);
    }

    public void setBulkParameters(int nr, int mr) {
        this.non_rep = nr;
        this.max_rep = mr;
    }

    public void addOid(String[] oids) {
        int i = 0;
        while (i < oids.length) {
            varbind vb = new varbind(oids[i]);
            this.reqVarbinds.addElement(vb);
            ++i;
        }
    }

    public void setPduType(int newType) {
        this.type = newType;
    }

    public void setRetryIntervals(int[] retryIntervals) {
        this.retry_intervals = retryIntervals;
    }

    public AsnObject getResponseVariable() throws PduException, IOException {
        AsnObject value = null;
        varbind[] vars = this.sendAndWait();
        if (vars != null && vars.length > 0) {
            value = vars[0].getValue();
        }
        return value;
    }

    public AsnObject[] getResponseVariables() throws PduException, IOException {
        AsnObject[] values = null;
        varbind[] vars = this.sendAndWait();
        if (vars != null) {
            values = new AsnObject[vars.length];
            int i = 0;
            while (i < vars.length) {
                values[i] = vars[i].getValue();
                ++i;
            }
        }
        return values;
    }

    public varbind getResponseVariableBinding() throws PduException, IOException {
        varbind var = null;
        varbind[] vars = this.sendAndWait();
        if (vars != null && vars.length > 0) {
            var = vars[0];
        }
        return var;
    }

    public varbind[] getResponseVariableBindings() throws PduException, IOException {
        varbind[] vars = this.sendAndWait();
        return vars;
    }

    protected synchronized varbind[] sendAndWait() throws PduException, IOException {
        int sz = this.reqVarbinds.size();
        switch (this.type) {
            case 1: {
                this.pdu = new SetPdu_vec(this.context, sz);
                break;
            }
            case 2: {
                this.pdu = new GetNextPdu_vec(this.context, sz);
                break;
            }
            case 3: {
                this.pdu = new OneGetBulkPdu(this.context);
                ((OneGetBulkPdu)this.pdu).setNonRepeaters(this.non_rep);
                ((OneGetBulkPdu)this.pdu).setMaxRepetitions(this.max_rep);
                break;
            }
            default: {
                this.pdu = new GetPdu_vec(this.context, sz);
            }
        }
        int i = 0;
        while (i < sz) {
            varbind var = (varbind)this.reqVarbinds.elementAt(i);
            this.pdu.addOid(var);
            ++i;
        }
        if (this.retry_intervals != null) {
            this.pdu.setRetryIntervals(this.retry_intervals);
        }
        this.pdu.send();
        this.pdu.waitForSelf();
        varbind[] vars = this.pdu.getResponseVarbinds();
        return vars;
    }

    public int getErrorIndex() {
        return this.pdu.getErrorIndex();
    }

    public int getErrorStatus() {
        return this.pdu.getErrorStatus();
    }

    public String getErrorStatusString() {
        return this.pdu.getErrorStatusString();
    }
}

