/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import java.util.Date;
import java.util.Observer;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class UpSincePdu
extends Pdu {
    private static final String version_id = "@(#)$Id: UpSincePdu.java,v 3.13 2002/10/10 15:26:15 birgit Exp $ Copyright Westhawk Ltd";
    Date since;
    public static final String SYSUPTIME = "1.3.6.1.2.1.1.3.0";

    public UpSincePdu(SnmpContextBasisFace con, Observer o) throws PduException, IOException {
        super(con);
        this.addOid(SYSUPTIME);
        if (o != null) {
            this.addObserver(o);
        }
        this.send();
    }

    public Date getDate() {
        return this.since;
    }

    protected void new_value(int n, varbind res) {
        AsnObject val = res.getValue();
        if (val instanceof AsnUnsInteger) {
            AsnUnsInteger va = (AsnUnsInteger)res.getValue();
            if (n == 0) {
                long value = va.getValue();
                Date now = new Date();
                long then = now.getTime();
                this.since = new Date(then -= 10L * value);
            }
        } else {
            this.since = null;
        }
    }

    protected void tell_them() {
        this.notifyObservers(this.since);
    }
}

