/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class AsnOctets
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnOctets.java,v 3.31 2002/10/29 14:44:40 birgit Exp $ Copyright Westhawk Ltd";
    public static String HEX_PREFIX = "0x";
    byte[] value;
    private int hash = 0;

    public AsnOctets(char[] s) {
        this.value = new byte[s.length];
        this.type = (byte)4;
        int idx = 0;
        while (idx < s.length) {
            this.value[idx] = (byte)s[idx];
            ++idx;
        }
    }

    public AsnOctets(String s) {
        this(s.toCharArray());
    }

    public AsnOctets(byte[] s) throws IllegalArgumentException {
        this(s, 4);
    }

    public AsnOctets(InetAddress iad) throws IllegalArgumentException {
        this(iad.getAddress(), 64);
    }

    public AsnOctets(byte[] s, byte t) throws IllegalArgumentException {
        this.value = s;
        this.type = t;
        if (this.value == null) {
            throw new IllegalArgumentException("Value is null");
        }
    }

    public AsnOctets(InputStream in, int len) throws IOException {
        this.value = new byte[len];
        if (len != 0) {
            if (len == in.read(this.value, 0, len)) {
                String str = "";
                String string = new String(this.value);
            } else {
                throw new IOException("AsnOctets(): Not enough data");
            }
        }
    }

    public static void setHexPrefix(String newPrefix) {
        HEX_PREFIX = newPrefix;
    }

    public String getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value;
    }

    public String toString() {
        String str = "";
        if (this.type == 64) {
            str = this.toIpAddress();
        } else if (this.type == 68) {
            str = HEX_PREFIX + this.toHex();
        } else {
            int length = this.value.length;
            byte b = 32;
            byte e = 126;
            boolean isPrintable = true;
            int i = 0;
            while (i < length && isPrintable) {
                isPrintable = this.value[i] >= b && this.value[i] <= e || Character.isWhitespace((char)this.value[i]) || this.value[i] == 0;
                ++i;
            }
            str = isPrintable ? new String(this.value) : HEX_PREFIX + this.toHex();
        }
        return str;
    }

    int size() {
        return this.value.length;
    }

    void write(OutputStream out, int pos) throws IOException {
        this.AsnBuildHeader(out, this.type, this.value.length);
        if (AsnObject.debug > 10) {
            System.out.println("\tAsnOctets(): value = " + this.toString() + ", pos = " + pos);
        }
        int idx = 0;
        while (idx < this.value.length) {
            out.write(this.value[idx]);
            ++idx;
        }
    }

    public String toIpAddress() {
        String str = "";
        int length = this.value.length;
        if (length > 0) {
            long val;
            int i = 0;
            while (i < length - 1) {
                val = this.getPositiveValue(i);
                str = str + String.valueOf(val) + ".";
                ++i;
            }
            val = this.getPositiveValue(length - 1);
            str = str + String.valueOf(val);
        }
        return str;
    }

    private long getPositiveValue(int index) {
        long val = this.value[index];
        if (val < 0L) {
            val += 256L;
        }
        return val;
    }

    public String toHex() {
        StringBuffer buffer = new StringBuffer("");
        int length = this.value.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                buffer.append(SnmpUtilities.toHex(this.value[i])).append(":");
                ++i;
            }
            buffer.append(SnmpUtilities.toHex(this.value[length - 1]));
        }
        return buffer.toString();
    }

    public String toDisplayString() {
        String str = "";
        int length = this.value.length;
        if (length > 0) {
            str = new String(this.value);
        }
        return str;
    }

    public long[] toSubOid(boolean length_implied) {
        long[] sub_oid;
        int index = 0;
        int length = this.value.length;
        if (length_implied) {
            sub_oid = new long[length];
        } else {
            sub_oid = new long[length + 1];
            sub_oid[0] = length;
            ++index;
        }
        int i = 0;
        while (i < length) {
            sub_oid[index] = this.getPositiveValue(i);
            ++index;
            ++i;
        }
        return sub_oid;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof AsnOctets) {
            AsnOctets anotherOctet = (AsnOctets)anObject;
            int n = this.value.length;
            if (n == anotherOctet.value.length) {
                byte[] v1 = this.value;
                byte[] v2 = anotherOctet.value;
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = 0;
            byte[] val = this.value;
            int len = this.value.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + val[off++];
                ++i;
            }
            this.hash = h;
        }
        return h;
    }
}

