/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextFace;
import uk.co.westhawk.snmp.stack.SnmpContextPoolItem;

public class SnmpContextPool
implements SnmpContextFace {
    private static final String version_id = "@(#)$Id: SnmpContextPool.java,v 3.14 2002/11/06 11:27:59 birgit Exp $ Copyright Westhawk Ltd";
    protected static Hashtable contextPool;
    protected SnmpContext context = null;
    protected String hostAddr;
    protected String socketType;
    protected int hostPort;
    protected String community = "public";

    public SnmpContextPool(String host, int port) throws IOException {
        this(host, port, "Standard");
    }

    public SnmpContextPool(String host, int port, String typeSocket) throws IOException {
        this(host, port, "public", typeSocket);
    }

    public SnmpContextPool(String host, int port, String comm, String typeSocket) throws IOException {
        SnmpContextPool.initPools();
        this.hostAddr = host;
        this.hostPort = port;
        this.community = comm;
        this.socketType = typeSocket;
        this.context = this.getMatchingContext();
    }

    private static synchronized void initPools() {
        if (contextPool == null) {
            contextPool = new Hashtable(5);
        }
    }

    public int getVersion() {
        return 0;
    }

    public String getHost() {
        return this.hostAddr;
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getTypeSocket() {
        return this.socketType;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String newCommunity) {
        if (newCommunity != null && !newCommunity.equals(this.community)) {
            this.community = newCommunity;
            try {
                this.context = this.getMatchingContext();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean addPdu(Pdu pdu) throws IOException, PduException {
        try {
            if (this.context == null) {
                this.context = this.getMatchingContext();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.context.addPdu(pdu);
    }

    public boolean removePdu(int requestId) {
        boolean res = false;
        if (this.context != null) {
            res = this.context.removePdu(requestId);
        }
        return res;
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        byte[] res = null;
        if (this.context != null) {
            res = this.context.encodePacket(msg_type, rId, errstat, errind, ve);
        }
        return res;
    }

    public void sendPacket(byte[] packet) {
        if (this.context != null) {
            this.context.sendPacket(packet);
        }
    }

    public void destroy() {
        String hashKey = this.getHashKey();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(hashKey);
            if (item != null) {
                count = item.getCounter();
                item.setCounter(--count);
            }
            if (count <= 0) {
                contextPool.remove(hashKey);
                if (this.context != null) {
                    this.context.destroy();
                    this.context = null;
                }
            }
        }
    }

    protected SnmpContext getMatchingContext() throws IOException {
        SnmpContextPoolItem item = null;
        SnmpContext newContext = null;
        String hashKey = this.getHashKey();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            if (contextPool.containsKey(hashKey)) {
                item = (SnmpContextPoolItem)contextPool.get(hashKey);
                newContext = (SnmpContext)item.getContext();
                count = item.getCounter();
            } else {
                newContext = new SnmpContext(this.hostAddr, this.hostPort, this.socketType);
                newContext.setCommunity(this.community);
                item = new SnmpContextPoolItem(newContext);
                contextPool.put(hashKey, item);
            }
            item.setCounter(++count);
        }
        return newContext;
    }

    public void dumpContexts(String title) {
        System.out.println(title + " " + contextPool.size());
        Enumeration keys = contextPool.keys();
        int i = 0;
        Object c = null;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(key);
            if (item == null) continue;
            int count = item.getCounter();
            SnmpContext cntxt = (SnmpContext)item.getContext();
            System.out.println("\tcontext: " + key + ", count: " + count + ", index: " + i);
            if (cntxt == this.context) {
                System.out.println("\t\tcurrent context");
            }
            ++i;
        }
    }

    public String getHashKey() {
        String str = this.hostAddr + "_" + this.hostPort + "_" + this.socketType + "_" + this.community + "_v" + this.getVersion();
        return str;
    }

    public void addTrapListener(TrapListener l) throws IOException {
        if (this.context != null) {
            this.context.addTrapListener(l);
        }
    }

    public void removeTrapListener(TrapListener l) throws IOException {
        if (this.context != null) {
            this.context.removeTrapListener(l);
        }
    }

    public Pdu processIncomingTrap(byte[] message) throws DecodingException, IOException {
        Pdu pdu = null;
        if (this.context != null) {
            pdu = this.context.processIncomingTrap(message);
        }
        return pdu;
    }

    public String toString() {
        String res = "";
        if (this.context != null) {
            res = this.context.toString();
        }
        return res;
    }
}

