/*
 * $Id: Lose.java 456273 2005-03-21 14:21:50Z jonl $ $Revision: 456273 $
 * $Date: 2005-03-21 15:21:50 +0100 (Mon, 21 Mar 2005) $
 * 
 * ==================================================================== Licensed
 * under the Apache License, Version 2.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the
 * License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package wicket.examples.hangman;

import wicket.markup.html.basic.Label;
import wicket.markup.html.link.Link;

/**
 * Page that handles the loser failing to guess the word.
 * 
 * @author Chris Turner
 * @author Jonathan Locke
 */
public class Lose extends HangmanPage
{
	/**
	 * Create the lose page and its associated components.
	 */
	public Lose()
	{
		add(new Label("currentWord", getGame().getWord().asString()));
		add(new Link("playAgain")
		{
			public void onClick()
			{
				getGame().newGame();
				setResponsePage(new Guess());
			}
		});
	}

}
