/*
 * $Id: ModelIteratorAdapter.java 458265 2005-12-08 07:54:59Z ivaynberg $
 * $Revision: 458265 $
 * $Date: 2005-12-08 08:54:59 +0100 (Thu, 08 Dec 2005) $
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package wicket.extensions.markup.html.repeater.util;

import java.util.Iterator;

import wicket.extensions.markup.html.repeater.refreshing.RefreshingView;
import wicket.model.IModel;

/**
 * Iterator adapter that wraps adaptee's elements with a model. Convinient when
 * implementing {@link RefreshingView}.
 * 
 * @author Igor Vaynberg (ivaynberg)
 * 
 */
public abstract class ModelIteratorAdapter implements Iterator
{
	private Iterator delegate;

	/**
	 * Constructor
	 * 
	 * @param delegate
	 *            iterator that will be wrapped
	 */
	public ModelIteratorAdapter(Iterator delegate)
	{
		this.delegate = delegate;
	}

	/**
	 * @see java.util.Iterator#hasNext()
	 */
	public boolean hasNext()
	{
		return delegate.hasNext();
	}

	/**
	 * @see java.util.Iterator#next()
	 */
	public Object next()
	{
		return model(delegate.next());
	}

	/**
	 * @see java.util.Iterator#remove()
	 */
	public void remove()
	{
		delegate.remove();
	}

	/**
	 * This method is used to wrap the provided object with an implementation of
	 * IModel. The provided object is guaranteed to be returned from the
	 * delegate iterator.
	 * 
	 * @param object
	 *            object to be wrapped
	 * @return IModel wrapper for the object
	 */
	abstract protected IModel model(Object object);
}
