/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.ajax.markup.html;

import wicket.Component;
import wicket.MarkupContainer;
import wicket.RequestCycle;
import wicket.ajax.AbstractDefaultAjaxBehavior;
import wicket.ajax.AjaxEventBehavior;
import wicket.ajax.AjaxRequestTarget;
import wicket.behavior.IBehavior;
import wicket.markup.ComponentTag;
import wicket.markup.MarkupStream;
import wicket.markup.html.basic.Label;
import wicket.markup.html.form.FormComponent;
import wicket.markup.html.form.TextField;
import wicket.markup.html.form.validation.IValidator;
import wicket.markup.html.panel.Panel;
import wicket.model.AbstractModel;
import wicket.model.IModel;
import wicket.util.string.JavascriptUtils;

public class AjaxEditableLabel
extends Panel {
    private static final long serialVersionUID = 1L;
    private transient IModel tempModel;
    private FormComponent editor;
    private Component label;

    public AjaxEditableLabel(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.tempModel = new PassThroughModel();
    }

    public AjaxEditableLabel(String id, IModel model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.tempModel = model != null ? model : new PassThroughModel();
    }

    public final AjaxEditableLabel add(IValidator validator) {
        this.getEditor().add(validator);
        return this;
    }

    public final AjaxEditableLabel setLabel(IModel labelModel) {
        this.getEditor().setLabel(labelModel);
        return this;
    }

    public final Component setModel(IModel model) {
        super.setModel(model);
        this.getEditor().setModel(model);
        return this;
    }

    public final AjaxEditableLabel setRequired(boolean required) {
        this.getEditor().setRequired(required);
        return this;
    }

    public final AjaxEditableLabel setType(Class type) {
        this.getEditor().setType(type);
        return this;
    }

    protected FormComponent newEditor(MarkupContainer parent, String componentId, IModel model) {
        TextField editor = new TextField(componentId, model);
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add((IBehavior)new EditorAjaxBehavior());
        return editor;
    }

    protected Component newLabel(MarkupContainer parent, String componentId, IModel model) {
        Label label = new Label("label", model){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                if (this.getModelObject() == null) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add((IBehavior)new LabelAjaxBehavior("onclick"));
        return label;
    }

    protected final FormComponent getEditor() {
        if (this.editor == null) {
            this.initLabelAndEditor();
        }
        return this.editor;
    }

    protected final Component getLabel() {
        return this.label;
    }

    protected void internalOnAttach() {
        if (this.tempModel != null) {
            this.initLabelAndEditor();
        }
    }

    protected void onCancel(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        target.addComponent((Component)this);
    }

    protected void onEdit(AjaxRequestTarget target) {
        this.label.setVisible(false);
        this.editor.setVisible(true);
        target.addComponent((Component)this);
        target.appendJavascript("{ var el=wicketGet('" + this.editor.getMarkupId() + "');" + "  el.focus(); " + "  if (el.createTextRange) { " + "     var v = el.value; var r = el.createTextRange(); " + "     r.moveStart('character', v.length); r.select(); } }");
    }

    protected void onError(AjaxRequestTarget target) {
        String errorMessage = this.editor.getFeedbackMessage().getMessage();
        if (errorMessage != null) {
            target.appendJavascript("window.status='" + JavascriptUtils.escapeQuotes((CharSequence)errorMessage) + "';");
        }
        String editorMarkupId = this.editor.getMarkupId();
        target.appendJavascript(editorMarkupId + ".select();");
        target.appendJavascript(editorMarkupId + ".focus();");
        target.addComponent((Component)this.editor);
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.label.setVisible(true);
        this.editor.setVisible(false);
        target.addComponent((Component)this);
        target.appendJavascript("window.status='';");
    }

    private void initLabelAndEditor() {
        this.editor = this.newEditor((MarkupContainer)this, "editor", this.tempModel);
        this.label = this.newLabel((MarkupContainer)this, "label", this.tempModel);
        this.add(this.label);
        this.add((Component)this.editor);
        this.tempModel = null;
    }

    protected String defaultNullLabel() {
        return "...";
    }

    private final class PassThroughModel
    extends AbstractModel {
        private static final long serialVersionUID = 1L;

        private PassThroughModel() {
        }

        public Object getObject(Component component) {
            return AjaxEditableLabel.this.getModel().getObject((Component)AjaxEditableLabel.this);
        }

        public void setObject(Component component, Object object) {
            AjaxEditableLabel.this.getModel().setObject((Component)AjaxEditableLabel.this, object);
        }
    }

    protected class LabelAjaxBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        public LabelAjaxBehavior(String event) {
            super(event);
        }

        protected void onEvent(AjaxRequestTarget target) {
            AjaxEditableLabel.this.onEdit(target);
        }
    }

    protected class EditorAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            String saveCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=true&'+this.name+'='+wicketEncode(this.value)); return true;}";
            String cancelCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=false'); return false;}";
            String keypress = "var kc=wicketKeyCode(event); if (kc==27) " + cancelCall + " else if (kc!=13) { return true; } else " + saveCall;
            tag.put("onblur", (CharSequence)saveCall);
            tag.put("onkeypress", (CharSequence)keypress);
        }

        protected void respond(AjaxRequestTarget target) {
            RequestCycle requestCycle = RequestCycle.get();
            boolean save = Boolean.valueOf(requestCycle.getRequest().getParameter("save"));
            if (save) {
                AjaxEditableLabel.this.editor.processInput();
                if (AjaxEditableLabel.this.editor.isValid()) {
                    AjaxEditableLabel.this.onSubmit(target);
                } else {
                    AjaxEditableLabel.this.onError(target);
                }
            } else {
                AjaxEditableLabel.this.onCancel(target);
            }
        }
    }
}

