/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.ajax.markup.html;

import wicket.AttributeModifier;
import wicket.Component;
import wicket.MarkupContainer;
import wicket.behavior.IBehavior;
import wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import wicket.markup.ComponentTag;
import wicket.markup.MarkupStream;
import wicket.markup.html.basic.MultiLineLabel;
import wicket.markup.html.form.FormComponent;
import wicket.markup.html.form.TextArea;
import wicket.model.AbstractReadOnlyModel;
import wicket.model.IModel;

public class AjaxEditableMultiLineLabel
extends AjaxEditableLabel {
    private static final long serialVersionUID = 1L;
    private int rows = 10;
    private int cols = 40;

    public AjaxEditableMultiLineLabel(String id) {
        super(id);
    }

    public AjaxEditableMultiLineLabel(String id, IModel model) {
        super(id, model);
    }

    protected Component newLabel(MarkupContainer parent, String componentId, IModel model) {
        MultiLineLabel label = new MultiLineLabel(componentId, model){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                if (this.getModelObject() == null) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableMultiLineLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add((IBehavior)new AjaxEditableLabel.LabelAjaxBehavior("onclick"));
        return label;
    }

    protected FormComponent newEditor(MarkupContainer parent, String componentId, IModel model) {
        TextArea editor = new TextArea(componentId, model);
        editor.add((IBehavior)new AttributeModifier("rows", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject(Component c) {
                return new Integer(AjaxEditableMultiLineLabel.this.rows);
            }
        }));
        editor.add((IBehavior)new AttributeModifier("cols", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject(Component c) {
                return new Integer(AjaxEditableMultiLineLabel.this.cols);
            }
        }));
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add((IBehavior)new AjaxEditableLabel.EditorAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String saveCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=true&'+this.name+'='+wicketEncode(this.value)); return true;}";
                String cancelCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=false'); return false;}";
                String keypress = "var kc=wicketKeyCode(event); if (kc==27) " + cancelCall + "; ";
                tag.put("onblur", (CharSequence)saveCall);
                tag.put("onkeypress", (CharSequence)keypress);
            }
        });
        return editor;
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int cols) {
        this.cols = cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int rows) {
        this.rows = rows;
    }

    protected String defaultNullLabel() {
        return "...";
    }
}

