/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.ajax.markup.html.autocomplete;

import java.util.Iterator;
import wicket.Application;
import wicket.IRequestTarget;
import wicket.RequestCycle;
import wicket.Response;
import wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteBehavior;
import wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import wicket.protocol.http.WebResponse;

public abstract class AutoCompleteBehavior
extends AbstractAutoCompleteBehavior {
    private static final long serialVersionUID = 1L;
    private final IAutoCompleteRenderer renderer;

    public AutoCompleteBehavior(IAutoCompleteRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("renderer cannot be null");
        }
        this.renderer = renderer;
    }

    protected final void onRequest(final String val, RequestCycle requestCycle) {
        IRequestTarget target = new IRequestTarget(){

            public void respond(RequestCycle requestCycle) {
                WebResponse r = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                r.setCharacterEncoding(encoding);
                r.setContentType("text/xml; charset=" + encoding);
                r.setHeader("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
                r.setHeader("Cache-Control", "no-cache, must-revalidate");
                r.setHeader("Pragma", "no-cache");
                Iterator comps = AutoCompleteBehavior.this.getChoices(val);
                AutoCompleteBehavior.this.renderer.renderHeader((Response)r);
                while (comps.hasNext()) {
                    Object comp = comps.next();
                    AutoCompleteBehavior.this.renderer.render(comp, (Response)r, val);
                }
                AutoCompleteBehavior.this.renderer.renderFooter((Response)r);
            }

            public void detach(RequestCycle requestCycle) {
            }

            public Object getLock(RequestCycle requestCycle) {
                return requestCycle.getSession();
            }
        };
        requestCycle.setRequestTarget(target);
    }

    protected abstract Iterator getChoices(String var1);
}

