/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.ajax.markup.html.form.upload;

import javax.servlet.http.HttpServletRequest;
import wicket.RequestCycle;
import wicket.WicketRuntimeException;
import wicket.extensions.ajax.markup.html.form.upload.UploadInfo;
import wicket.protocol.http.WebRequest;
import wicket.protocol.http.servlet.MultipartServletWebRequest;
import wicket.protocol.http.servlet.ServletWebRequest;
import wicket.util.lang.Bytes;
import wicket.util.upload.FileUploadException;

public class UploadWebRequest
extends ServletWebRequest {
    final HttpServletRequest req;
    private static final String SESSION_KEY = (class$wicket$extensions$ajax$markup$html$form$upload$UploadWebRequest == null ? (class$wicket$extensions$ajax$markup$html$form$upload$UploadWebRequest = UploadWebRequest.class$("wicket.extensions.ajax.markup.html.form.upload.UploadWebRequest")) : class$wicket$extensions$ajax$markup$html$form$upload$UploadWebRequest).getName();
    static /* synthetic */ Class class$wicket$extensions$ajax$markup$html$form$upload$UploadWebRequest;

    public UploadWebRequest(HttpServletRequest req) {
        super(req);
        this.req = req;
    }

    public WebRequest newMultipartWebRequest(Bytes maxsize) {
        try {
            return new MultipartRequest(this.req, maxsize);
        }
        catch (FileUploadException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    static UploadInfo getUploadInfo(HttpServletRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("req cannot be null");
        }
        return (UploadInfo)req.getSession().getAttribute(SESSION_KEY);
    }

    static void setUploadInfo(HttpServletRequest req, UploadInfo uploadInfo) {
        if (req == null) {
            throw new IllegalArgumentException("req cannot be null");
        }
        if (uploadInfo == null) {
            throw new IllegalArgumentException("uploadInfo cannot be null");
        }
        req.getSession().setAttribute(SESSION_KEY, (Object)uploadInfo);
    }

    static void clearUploadInfo(HttpServletRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("req cannot be null");
        }
        req.getSession().removeAttribute(SESSION_KEY);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MultipartRequest
    extends MultipartServletWebRequest {
        public MultipartRequest(HttpServletRequest req, Bytes maxSize) throws FileUploadException {
            super(req, maxSize);
            if (req == null) {
                throw new IllegalStateException("req cannot be null");
            }
        }

        protected boolean wantUploadProgressUpdates() {
            return true;
        }

        protected void onUploadStarted(int totalBytes) {
            UploadInfo info = new UploadInfo(totalBytes);
            HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
            UploadWebRequest.setUploadInfo(request, info);
        }

        protected void onUploadUpdate(int bytesUploaded, int total) {
            HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
            UploadInfo info = UploadWebRequest.getUploadInfo(request);
            if (info == null) {
                throw new IllegalStateException("could not find UploadInfo object in session which should have been set when uploaded started");
            }
            info.setBytesUploaded(bytesUploaded);
            UploadWebRequest.setUploadInfo(request, info);
        }

        protected void onUploadCompleted() {
            HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
            UploadWebRequest.clearUploadInfo(request);
        }
    }
}

