/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.ajax.markup.html.modal;

import java.io.Serializable;
import wicket.Application;
import wicket.Component;
import wicket.Page;
import wicket.PageMap;
import wicket.RequestCycle;
import wicket.ResourceReference;
import wicket.Session;
import wicket.WicketRuntimeException;
import wicket.ajax.AbstractDefaultAjaxBehavior;
import wicket.ajax.AjaxRequestTarget;
import wicket.ajax.IAjaxCallDecorator;
import wicket.ajax.calldecorator.CancelEventIfNoAjaxDecorator;
import wicket.behavior.HeaderContributor;
import wicket.behavior.IBehavior;
import wicket.markup.ComponentTag;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.panel.Panel;
import wicket.markup.html.resources.CompressedResourceReference;
import wicket.request.RequestParameters;
import wicket.util.lang.EnumeratedType;
import wicket.util.string.AppendingStringBuffer;
import wicket.util.string.Strings;

public class ModalWindow
extends Panel {
    private static final long serialVersionUID = 1L;
    private static ResourceReference JAVASCRIPT = new CompressedResourceReference(class$wicket$extensions$ajax$markup$html$modal$ModalWindow == null ? (class$wicket$extensions$ajax$markup$html$modal$ModalWindow = ModalWindow.class$("wicket.extensions.ajax.markup.html.modal.ModalWindow")) : class$wicket$extensions$ajax$markup$html$modal$ModalWindow, "res/modal.js");
    private static ResourceReference CSS = new CompressedResourceReference(class$wicket$extensions$ajax$markup$html$modal$ModalWindow == null ? (class$wicket$extensions$ajax$markup$html$modal$ModalWindow = ModalWindow.class$("wicket.extensions.ajax.markup.html.modal.ModalWindow")) : class$wicket$extensions$ajax$markup$html$modal$ModalWindow, "res/modal.css");
    public static final String CSS_CLASS_BLUE = "w_blue";
    public static final String CSS_CLASS_GRAY = "w_silver";
    private boolean deletePageMap = false;
    private boolean shown = false;
    private WebMarkupContainer empty;
    private int minimalWidth = 200;
    private int minimalHeight = 200;
    private String cssClassName = "w_blue";
    private int initialWidth = 600;
    private int initialHeight = 400;
    private boolean useInitialHeight = true;
    private boolean resizable = true;
    private String widthUnit = "px";
    private String heightUnit = "px";
    private String cookieName;
    private String title = null;
    private MaskType maskType = MaskType.SEMI_TRANSPARENT;
    private String pageMapName = "modal-dialog-pagemap";
    private PageCreator pageCreator = null;
    private CloseButtonCallback closeButtonCallback = null;
    private WindowClosedCallback windowClosedCallback = null;
    static /* synthetic */ Class class$wicket$extensions$ajax$markup$html$modal$ModalWindow;
    static /* synthetic */ Class class$wicket$extensions$ajax$markup$html$modal$ModalWindow$CloseButtonBehavior;
    static /* synthetic */ Class class$wicket$extensions$ajax$markup$html$modal$ModalWindow$WindowClosedBehavior;

    public ModalWindow(String id) {
        super(id);
        this.setVersioned(false);
        this.cookieName = null;
        this.empty = new WebMarkupContainer(this.getContentId());
        this.add((Component)this.empty);
        this.add((IBehavior)new CloseButtonBehavior());
        this.add((IBehavior)new WindowClosedBehavior());
        this.add((IBehavior)HeaderContributor.forJavaScript((ResourceReference)JAVASCRIPT));
        this.add((IBehavior)HeaderContributor.forCss((ResourceReference)CSS));
    }

    public void setPageMapName(String pageMapName) {
        this.pageMapName = pageMapName;
    }

    public String getPageMapName() {
        return this.pageMapName;
    }

    public void setPageCreator(PageCreator creator) {
        this.pageCreator = creator;
    }

    public void setCloseButtonCallback(CloseButtonCallback callback) {
        this.closeButtonCallback = callback;
    }

    public void setWindowClosedCallback(WindowClosedCallback callback) {
        this.windowClosedCallback = callback;
    }

    public void show(AjaxRequestTarget target) {
        target.addComponent((Component)this);
        target.appendJavascript(this.getWindowOpenJavascript());
        this.shown = true;
    }

    public static final void close(AjaxRequestTarget target) {
        target.appendJavascript(ModalWindow.getCloseJavacript());
    }

    private static String getCloseJavacript() {
        return "var win;\ntry {\n\twin = window.parent.Wicket.Window;\n} catch (ignore) {\n}\nif (typeof(win) == \"undefined\" || typeof(win.current) == \"undefined\") {\n  try {\n     win = window.Wicket.Window;\n  } catch (ignore) {\n  }\n}\nif (typeof(win) != \"undefined\" && typeof(win.current) != \"undefined\") {\n\twindow.parent.setTimeout(function() {\n\t\twin.current.close();\n\t}, 0);\n}";
    }

    public String getContentId() {
        return "content";
    }

    public void setMinimalWidth(int minimalWidth) {
        this.minimalWidth = minimalWidth;
    }

    public int getMinimalWidth() {
        return this.minimalWidth;
    }

    public void setMinimalHeight(int minimalHeight) {
        this.minimalHeight = minimalHeight;
    }

    public int getMinimalHeight() {
        return this.minimalHeight;
    }

    public void setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public void setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public void setUseInitialHeight(boolean useInitialHeight) {
        this.useInitialHeight = useInitialHeight;
    }

    public boolean isUseInitialHeight() {
        return this.useInitialHeight;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setHeightUnit(String heightUnit) {
        this.heightUnit = heightUnit;
    }

    public String getHeightUnit() {
        return this.heightUnit;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMaskType(MaskType mask) {
        this.maskType = mask;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page createPage() {
        if (this.pageCreator == null) {
            return null;
        }
        RequestParameters parameters = RequestCycle.get().getRequest().getRequestParameters();
        String oldPageMapName = parameters.getPageMapName();
        if (this.getPageMapName() != null && Application.get().getPageSettings().getAutomaticMultiWindowSupport()) {
            Session session = Session.get();
            if (session.pageMapForName(this.getPageMapName(), false) == null) {
                this.deletePageMap = true;
            }
            parameters.setPageMapName(this.getPageMapName());
        }
        try {
            Page page;
            Page page2 = page = this.pageCreator.createPage();
            return page2;
        }
        finally {
            parameters.setPageMapName(oldPageMapName);
        }
    }

    protected void onAttach() {
        this.getContent().setOutputMarkupId(true);
        this.getContent().setVisible(this.shown);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("style", (CharSequence)"display:none");
    }

    private Component getContent() {
        return this.get(this.getContentId());
    }

    private boolean isCustomComponent() {
        return this.getContent() != this.empty;
    }

    public void remove(Component component) {
        super.remove(component);
        if (component.getId().equals(this.getContentId())) {
            this.empty = new WebMarkupContainer(this.getContentId());
            this.add((Component)this.empty);
        }
    }

    public void setContent(Component component) {
        if (!component.getId().equals(this.getContentId())) {
            throw new WicketRuntimeException("Modal window content id is wrong.");
        }
        this.replace(component);
    }

    private String getContentMarkupId() {
        return this.getContent().getMarkupId();
    }

    private String escapeQuotes(String string) {
        if (string.indexOf(34) != -1) {
            string = ((Object)Strings.replaceAll((CharSequence)string, (CharSequence)"\"", (CharSequence)"\\\"")).toString();
        }
        return string;
    }

    private String getWindowOpenJavascript() {
        AbstractDefaultAjaxBehavior behavior;
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        if (this.isCustomComponent()) {
            buffer.append("var element = document.getElementById(\"" + this.getContentMarkupId() + "\");\n");
        }
        buffer.append("var settings = new Object();\n");
        buffer.append("settings.minWidth=" + this.getMinimalWidth() + ";\n");
        buffer.append("settings.minHeight=" + this.getMinimalHeight() + ";\n");
        buffer.append("settings.className=\"" + this.getCssClassName() + "\";\n");
        buffer.append("settings.width=\"" + this.getInitialWidth() + "\";\n");
        if (this.isUseInitialHeight() || !this.isCustomComponent()) {
            buffer.append("settings.height=\"" + this.getInitialHeight() + "\";\n");
        } else {
            buffer.append("settings.height=null;\n");
        }
        buffer.append("settings.resizable=" + Boolean.toString(this.isResizable()) + ";\n");
        if (!this.isResizable()) {
            buffer.append("settings.widthUnit=\"" + this.getWidthUnit() + "\";\n");
            buffer.append("settings.heightUnit=\"" + this.getHeightUnit() + "\";\n");
        }
        if (!this.isCustomComponent()) {
            Page page = this.createPage();
            if (page == null) {
                throw new WicketRuntimeException("Error creating page for modal dialog.");
            }
            buffer.append("settings.src=\"" + RequestCycle.get().urlFor(page) + "\";\n");
            if (this.getPageMapName() != null) {
                buffer.append("settings.iframeName=\"" + this.getPageMapName() + "\";\n");
            }
        } else {
            buffer.append("settings.element = element;\n");
        }
        if (this.getCookieName() != null) {
            buffer.append("settings.cookieId=\"" + this.getCookieName() + "\";\n");
        }
        if (this.getTitle() != null) {
            buffer.append("settings.title=\"" + this.escapeQuotes(this.getTitle()) + "\";\n");
        }
        if (this.getMaskType() == MaskType.TRANSPARENT) {
            buffer.append("settings.mask=\"transparent\";\n");
        } else if (this.getMaskType() == MaskType.SEMI_TRANSPARENT) {
            buffer.append("settings.mask=\"semi-transparent\";\n");
        }
        if (this.closeButtonCallback != null) {
            behavior = (CloseButtonBehavior)((Object)this.getBehaviors(class$wicket$extensions$ajax$markup$html$modal$ModalWindow$CloseButtonBehavior == null ? (class$wicket$extensions$ajax$markup$html$modal$ModalWindow$CloseButtonBehavior = ModalWindow.class$("wicket.extensions.ajax.markup.html.modal.ModalWindow$CloseButtonBehavior")) : class$wicket$extensions$ajax$markup$html$modal$ModalWindow$CloseButtonBehavior).get(0));
            buffer.append("settings.onCloseButton = function() { " + behavior.getCallbackScript() + "};\n");
        }
        behavior = (WindowClosedBehavior)((Object)this.getBehaviors(class$wicket$extensions$ajax$markup$html$modal$ModalWindow$WindowClosedBehavior == null ? (class$wicket$extensions$ajax$markup$html$modal$ModalWindow$WindowClosedBehavior = ModalWindow.class$("wicket.extensions.ajax.markup.html.modal.ModalWindow$WindowClosedBehavior")) : class$wicket$extensions$ajax$markup$html$modal$ModalWindow$WindowClosedBehavior).get(0));
        buffer.append("settings.onClose = function() { " + behavior.getCallbackScript() + " };\n");
        buffer.append("Wicket.Window.create(settings).show();\n");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CloseButtonBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private CloseButtonBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            if (ModalWindow.this.closeButtonCallback == null || ModalWindow.this.closeButtonCallback.onCloseButtonClicked(target)) {
                target.appendJavascript("Wicket.Window.get().close();");
            }
        }

        protected IAjaxCallDecorator getAjaxCallDecorator() {
            return new CancelEventIfNoAjaxDecorator(super.getAjaxCallDecorator());
        }

        protected CharSequence getCallbackScript() {
            return super.getCallbackScript();
        }
    }

    private class WindowClosedBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private WindowClosedBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            Session session;
            PageMap pageMap;
            ModalWindow.this.shown = false;
            if (ModalWindow.this.deletePageMap && (pageMap = (session = Session.get()).pageMapForName(ModalWindow.this.getPageMapName(), false)) != null) {
                session.removePageMap(pageMap);
                ModalWindow.this.deletePageMap = false;
            }
            if (ModalWindow.this.windowClosedCallback != null) {
                ModalWindow.this.windowClosedCallback.onClose(target);
            }
        }

        protected CharSequence getCallbackScript() {
            return super.getCallbackScript();
        }
    }

    public static final class MaskType
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        public static final MaskType TRANSPARENT = new MaskType("TRANSPARENT");
        public static final MaskType SEMI_TRANSPARENT = new MaskType("SEMI_TRANSPARENT");

        public MaskType(String name) {
            super(name);
        }
    }

    public static interface WindowClosedCallback
    extends Serializable {
        public void onClose(AjaxRequestTarget var1);
    }

    public static interface CloseButtonCallback
    extends Serializable {
        public boolean onCloseButtonClicked(AjaxRequestTarget var1);
    }

    public static interface PageCreator
    extends Serializable {
        public Page createPage();
    }
}

