/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import wicket.Component;
import wicket.extensions.breadcrumb.BreadCrumbLink;
import wicket.extensions.breadcrumb.BreadCrumbModelListenerSupport;
import wicket.extensions.breadcrumb.IBreadCrumbModel;
import wicket.extensions.breadcrumb.IBreadCrumbModelListener;
import wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import wicket.markup.html.basic.Label;
import wicket.markup.html.list.ListItem;
import wicket.markup.html.list.ListView;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;
import wicket.model.LoadableDetachableModel;

public class BreadCrumbBar
extends Panel
implements IBreadCrumbModel {
    private static final long serialVersionUID = 1L;
    private IBreadCrumbParticipant activeParticipant = null;
    private List crumbs = new ArrayList();
    private final BreadCrumbModelListenerSupport listenerSupport = new BreadCrumbModelListenerSupport();

    public BreadCrumbBar(String id) {
        this(id, true);
    }

    public BreadCrumbBar(String id, boolean addDefaultCssStyle) {
        super(id);
        BreadCrumbsListView breadCrumbsListView = new BreadCrumbsListView("crumbs");
        this.addListener(breadCrumbsListView);
        this.add((Component)breadCrumbsListView);
    }

    public final void addDefaultCssStyle() {
    }

    public final void addListener(IBreadCrumbModelListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public final List allBreadCrumbParticipants() {
        return this.crumbs;
    }

    public IBreadCrumbParticipant getActive() {
        return this.activeParticipant;
    }

    public final void removeListener(IBreadCrumbModelListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    public final void setActive(IBreadCrumbParticipant breadCrumbParticipant) {
        int len;
        for (int i = len = this.crumbs.size() - 1; i > -1; --i) {
            IBreadCrumbParticipant temp = (IBreadCrumbParticipant)this.crumbs.get(i);
            if (!breadCrumbParticipant.equals(temp)) continue;
            int j = len;
            while (j > i) {
                IBreadCrumbParticipant removed = (IBreadCrumbParticipant)this.crumbs.remove(j--);
                this.listenerSupport.fireBreadCrumbRemoved(removed);
            }
            this.activate(breadCrumbParticipant);
            return;
        }
        this.crumbs.add(breadCrumbParticipant);
        this.listenerSupport.fireBreadCrumbAdded(breadCrumbParticipant);
        this.activate(breadCrumbParticipant);
    }

    protected final void activate(IBreadCrumbParticipant breadCrumbParticipant) {
        IBreadCrumbParticipant previousParticipant = this.activeParticipant;
        this.activeParticipant = breadCrumbParticipant;
        this.listenerSupport.fireBreadCrumbActivated(previousParticipant, breadCrumbParticipant);
        breadCrumbParticipant.onActivate(previousParticipant);
    }

    protected boolean getEnableLinkToCurrent() {
        return false;
    }

    protected Component newBreadCrumbComponent(String id, int index, int total, IBreadCrumbParticipant breadCrumbParticipant) {
        boolean enableLink = this.getEnableLinkToCurrent() || index < total - 1;
        return new BreadCrumbComponent(id, index, this, breadCrumbParticipant, enableLink);
    }

    private static final class BreadCrumbComponent
    extends Panel {
        private static final long serialVersionUID = 1L;

        public BreadCrumbComponent(String id, int index, IBreadCrumbModel breadCrumbModel, IBreadCrumbParticipant breadCrumbParticipant, boolean enableLink) {
            super(id);
            this.add(new Label("sep", index > 0 ? "/" : "").setEscapeModelStrings(false).setRenderBodyOnly(true));
            BreadCrumbLink link = new BreadCrumbLink(this, "link", breadCrumbModel, breadCrumbParticipant){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ IBreadCrumbParticipant val$breadCrumbParticipant;
                private final /* synthetic */ BreadCrumbComponent this$0;
                {
                    this.this$0 = this$0;
                    this.val$breadCrumbParticipant = val$breadCrumbParticipant;
                }

                protected IBreadCrumbParticipant getParticipant(String componentId) {
                    return this.val$breadCrumbParticipant;
                }
            };
            link.setEnabled(enableLink);
            this.add((Component)link);
            link.add(new Label("label", breadCrumbParticipant.getTitle()).setRenderBodyOnly(true));
        }
    }

    protected class BreadCrumbsListView
    extends ListView
    implements IBreadCrumbModelListener {
        private static final long serialVersionUID = 1L;
        private transient boolean attachedButNotRendered = false;
        private transient boolean dirty = false;
        private transient int size;

        public BreadCrumbsListView(String id) {
            super(id);
            this.setReuseItems(false);
            this.setModel((IModel)new LoadableDetachableModel(this){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ BreadCrumbsListView this$1;
                {
                    this.this$1 = this$1;
                }

                protected Object load() {
                    ArrayList<E> l = new ArrayList<E>(BreadCrumbsListView.access$000(this.this$1).allBreadCrumbParticipants());
                    BreadCrumbsListView.access$102(this.this$1, l.size());
                    return l;
                }
            });
        }

        public void breadCrumbActivated(IBreadCrumbParticipant previousParticipant, IBreadCrumbParticipant breadCrumbParticipant) {
            this.signalModelChange();
        }

        public void breadCrumbAdded(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        public void breadCrumbRemoved(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        protected void internalOnAttach() {
            if (this.dirty) {
                super.internalOnAttach();
                this.dirty = false;
            }
            this.attachedButNotRendered = true;
        }

        protected void onBeforeRender() {
            this.attachedButNotRendered = false;
        }

        protected void populateItem(ListItem item) {
            int index = item.getIndex();
            IBreadCrumbParticipant breadCrumbParticipant = (IBreadCrumbParticipant)item.getModelObject();
            item.add(BreadCrumbBar.this.newBreadCrumbComponent("crumb", index, this.size, breadCrumbParticipant));
        }

        private void signalModelChange() {
            if (!this.attachedButNotRendered) {
                this.dirty = true;
            } else {
                this.getModel().detach();
                super.internalOnAttach();
            }
        }

        static /* synthetic */ BreadCrumbBar access$000(BreadCrumbsListView x0) {
            return x0.BreadCrumbBar.this;
        }

        static /* synthetic */ int access$102(BreadCrumbsListView x0, int x1) {
            x0.size = x1;
            return x0.size;
        }
    }
}

