/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.breadcrumb.panel;

import wicket.Component;
import wicket.MarkupContainer;
import wicket.extensions.breadcrumb.IBreadCrumbModel;
import wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import wicket.extensions.breadcrumb.panel.IBreadCrumbPanelFactory;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;
import wicket.version.undo.Change;

public abstract class BreadCrumbPanel
extends Panel
implements IBreadCrumbParticipant {
    private static final long serialVersionUID = 1L;
    private IBreadCrumbModel breadCrumbModel;
    static /* synthetic */ Class class$wicket$Component;

    public BreadCrumbPanel(String id, IBreadCrumbModel breadCrumbModel) {
        super(id);
        this.breadCrumbModel = breadCrumbModel;
    }

    public BreadCrumbPanel(String id, IBreadCrumbModel breadCrumbModel, IModel model) {
        super(id, model);
        this.breadCrumbModel = breadCrumbModel;
    }

    public void activate(IBreadCrumbPanelFactory breadCrumbPanelFactory) {
        this.activate(breadCrumbPanelFactory.create(this.getId(), this.breadCrumbModel));
    }

    public void activate(IBreadCrumbParticipant participant) {
        final IBreadCrumbParticipant active = this.breadCrumbModel.getActive();
        if (active == null) {
            throw new IllegalStateException("The model has no active bread crumb. Before using " + this + ", you have to have at least one bread crumb in the model");
        }
        this.addStateChange(new Change(){
            private static final long serialVersionUID = 1L;

            public void undo() {
                BreadCrumbPanel.this.breadCrumbModel.setActive(active);
            }
        });
        this.breadCrumbModel.setActive(participant);
    }

    public final IBreadCrumbModel getBreadCrumbModel() {
        return this.breadCrumbModel;
    }

    public Component getComponent() {
        return this;
    }

    public void onActivate(IBreadCrumbParticipant previous) {
        if (previous != null) {
            MarkupContainer parent = previous.getComponent().getParent();
            if (parent != null) {
                final String thisId = this.getId();
                if (parent.get(thisId) != null) {
                    parent.replace((Component)this);
                } else {
                    Component c = (Component)parent.visitChildren(new Component.IVisitor(){

                        public Object component(Component component) {
                            if (component.getId().equals(thisId)) {
                                return component;
                            }
                            return Component.IVisitor.CONTINUE_TRAVERSAL;
                        }
                    });
                    if (c == null) {
                        c = (Component)parent.visitParents(class$wicket$Component == null ? (class$wicket$Component = BreadCrumbPanel.class$("wicket.Component")) : class$wicket$Component, new Component.IVisitor(){

                            public Object component(Component component) {
                                if (component.getId().equals(thisId)) {
                                    return component;
                                }
                                return Component.IVisitor.CONTINUE_TRAVERSAL;
                            }
                        });
                    }
                    if (c != null) {
                        c.replaceWith((Component)this);
                    }
                }
            }
        } else if (this.getParent() != null) {
            this.getParent().replace((Component)this);
        }
    }

    public final void setBreadCrumbModel(IBreadCrumbModel breadCrumbModel) {
        this.breadCrumbModel = breadCrumbModel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String getTitle();
}

