/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.captcha;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import wicket.markup.html.image.resource.DynamicImageResource;
import wicket.util.time.Time;

public final class CaptchaImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private String challengeId;
    private final List charAttsList;
    private List fontNames = Arrays.asList("Helventica", "Arial", "Courier");
    private final int fontSize;
    private final int fontStyle;
    private int height = 0;
    private transient SoftReference imageData;
    private final int margin;
    private int width = 0;

    private static int randomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private static String randomString(int min, int max) {
        int num = CaptchaImageResource.randomInt(min, max);
        byte[] b = new byte[num];
        for (int i = 0; i < num; ++i) {
            b[i] = (byte)CaptchaImageResource.randomInt(97, 122);
        }
        return new String(b);
    }

    public CaptchaImageResource() {
        this(CaptchaImageResource.randomString(6, 8));
    }

    public CaptchaImageResource(String challengeId) {
        this(challengeId, 48, 30);
    }

    public CaptchaImageResource(String challengeId, int fontSize, int margin) {
        this.challengeId = challengeId;
        this.fontStyle = 1;
        this.fontSize = fontSize;
        this.margin = margin;
        this.width = this.margin * 2;
        this.height = this.margin * 2;
        char[] chars = challengeId.toCharArray();
        this.charAttsList = new ArrayList();
        for (int i = 0; i < chars.length; ++i) {
            String fontName = (String)this.fontNames.get(CaptchaImageResource.randomInt(0, this.fontNames.size()));
            double rotation = Math.toRadians(CaptchaImageResource.randomInt(-35, 35));
            int rise = CaptchaImageResource.randomInt(margin / 2, margin);
            Random ran = new Random();
            double shearX = ran.nextDouble() * 0.2;
            double shearY = ran.nextDouble() * 0.2;
            CharAttributes cf = new CharAttributes(chars[i], fontName, rotation, rise, shearX, shearY);
            this.charAttsList.add(cf);
            TextLayout text = new TextLayout(chars[i] + "", this.getFont(fontName), new FontRenderContext(null, false, false));
            AffineTransform textAt = new AffineTransform();
            textAt.rotate(rotation);
            textAt.shear(shearX, shearY);
            Shape shape = text.getOutline(textAt);
            this.width += (int)shape.getBounds2D().getWidth();
            if (this.height >= (int)shape.getBounds2D().getHeight() + rise) continue;
            this.height = (int)shape.getBounds2D().getHeight() + rise;
        }
    }

    public final String getChallengeId() {
        return this.challengeId;
    }

    public final void invalidate() {
        this.imageData = null;
    }

    protected final byte[] getImageData() {
        byte[] data = null;
        if (this.imageData != null) {
            data = (byte[])this.imageData.get();
        }
        if (data == null) {
            data = this.render();
            this.imageData = new SoftReference<byte[]>(data);
            this.setLastModifiedTime(Time.now());
        }
        return data;
    }

    private Font getFont(String fontName) {
        return new Font(fontName, this.fontStyle, this.fontSize);
    }

    private final byte[] render() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D gfx = (Graphics2D)image.getGraphics();
        gfx.setBackground(Color.WHITE);
        int curWidth = this.margin;
        for (int i = 0; i < this.charAttsList.size(); ++i) {
            CharAttributes cf = (CharAttributes)this.charAttsList.get(i);
            TextLayout text = new TextLayout(cf.getChar() + "", this.getFont(cf.getName()), gfx.getFontRenderContext());
            AffineTransform textAt = new AffineTransform();
            textAt.translate(curWidth, this.height - cf.getRise());
            textAt.rotate(cf.getRotation());
            textAt.shear(cf.getShearX(), cf.getShearY());
            Shape shape = text.getOutline(textAt);
            curWidth = (int)((double)curWidth + shape.getBounds().getWidth());
            gfx.setXORMode(Color.BLACK);
            gfx.fill(shape);
        }
        int dx = CaptchaImageResource.randomInt(this.width, 2 * this.width);
        int dy = CaptchaImageResource.randomInt(this.width, 2 * this.height);
        int x = CaptchaImageResource.randomInt(0, this.width / 2);
        int y = CaptchaImageResource.randomInt(0, this.height / 2);
        gfx.setXORMode(Color.BLACK);
        gfx.setStroke(new BasicStroke(CaptchaImageResource.randomInt(this.fontSize / 8, this.fontSize / 2)));
        gfx.drawOval(x, y, dx, dy);
        WritableRaster rstr = image.getRaster();
        int[] vColor = new int[3];
        int[] oldColor = new int[3];
        Random vRandom = new Random(System.currentTimeMillis());
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                rstr.getPixel(x, y, oldColor);
                vColor[0] = 0 + (int)(Math.floor((double)vRandom.nextFloat() * 1.03) * 255.0);
                vColor[0] = vColor[0] ^ 170 + (int)(vRandom.nextFloat() * 80.0f);
                vColor[0] = vColor[0] ^ oldColor[0];
                vColor[1] = vColor[0];
                vColor[2] = vColor[0];
                rstr.setPixel(x, y, vColor);
            }
        }
        return this.toImageData(image);
    }

    private static final class CharAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private char c;
        private String name;
        private int rise;
        private double rotation;
        private double shearX;
        private double shearY;

        CharAttributes(char c, String name, double rotation, int rise, double shearX, double shearY) {
            this.c = c;
            this.name = name;
            this.rotation = rotation;
            this.rise = rise;
            this.shearX = shearX;
            this.shearY = shearY;
        }

        char getChar() {
            return this.c;
        }

        String getName() {
            return this.name;
        }

        int getRise() {
            return this.rise;
        }

        double getRotation() {
            return this.rotation;
        }

        double getShearX() {
            return this.shearX;
        }

        double getShearY() {
            return this.shearY;
        }
    }
}

