/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.datepicker;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import wicket.AttributeModifier;
import wicket.Component;
import wicket.ResourceReference;
import wicket.behavior.IBehavior;
import wicket.extensions.markup.html.datepicker.DatePickerSettings;
import wicket.markup.ComponentTag;
import wicket.markup.MarkupStream;
import wicket.markup.html.WebComponent;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.panel.Panel;
import wicket.markup.html.resources.JavaScriptReference;
import wicket.markup.html.resources.StyleSheetReference;
import wicket.model.IModel;
import wicket.model.Model;
import wicket.util.convert.Converter;
import wicket.util.convert.IConverter;
import wicket.util.convert.ITypeConverter;
import wicket.util.convert.converters.DateConverter;
import wicket.util.string.AppendingStringBuffer;

public class DatePicker
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Component target;
    private TriggerButton triggerButton;
    private final DatePickerSettings settings;
    private DateConverter dateConverter;
    static /* synthetic */ Class class$wicket$extensions$markup$html$datepicker$DatePicker;
    static /* synthetic */ Class class$java$util$Date;

    public DatePicker(String id, Component target) {
        this(id, target, new DatePickerSettings());
    }

    public DatePicker(String id, Component label, Component target) {
        this(id, label, target, new DatePickerSettings());
    }

    public DatePicker(String id, Component target, DatePickerSettings settings) {
        this(id, null, target, settings);
    }

    public DatePicker(String id, Component label, Component target, final DatePickerSettings settings) {
        super(id);
        if (settings == null) {
            throw new IllegalArgumentException("Settings must be non null when using this constructor");
        }
        this.settings = settings;
        if (target == null) {
            throw new IllegalArgumentException("Target must be not null");
        }
        target.add((IBehavior)new PathAttributeModifier("id", target));
        this.target = target;
        if (label != null) {
            label.add((IBehavior)new PathAttributeModifier("for", target));
        }
        this.triggerButton = new TriggerButton("trigger", settings.getIcon());
        this.add((Component)this.triggerButton);
        this.add((Component)new InitScript("script"));
        this.add((Component)new JavaScriptReference("calendarMain", class$wicket$extensions$markup$html$datepicker$DatePicker == null ? (class$wicket$extensions$markup$html$datepicker$DatePicker = DatePicker.class$("wicket.extensions.markup.html.datepicker.DatePicker")) : class$wicket$extensions$markup$html$datepicker$DatePicker, "calendar.js"));
        this.add((Component)new JavaScriptReference("calendarSetup", class$wicket$extensions$markup$html$datepicker$DatePicker == null ? (class$wicket$extensions$markup$html$datepicker$DatePicker = DatePicker.class$("wicket.extensions.markup.html.datepicker.DatePicker")) : class$wicket$extensions$markup$html$datepicker$DatePicker, "calendar-setup.js"));
        this.add((Component)new JavaScriptReference("calendarLanguage", (IModel)new Model(){
            private static final long serialVersionUID = 1L;

            public Object getObject(Component component) {
                return settings.getLanguage(DatePicker.this.getLocale());
            }
        }));
        this.add((Component)new StyleSheetReference("calendarStyle", settings.getStyle()));
    }

    public void setDateConverter(DateConverter dateConverter) {
        this.dateConverter = dateConverter;
    }

    private CharSequence getInitScript() {
        DateFormat df;
        String targetId = this.target.getOutputMarkupId() ? this.target.getMarkupId() : this.target.getPath();
        AppendingStringBuffer b = new AppendingStringBuffer((CharSequence)"\nCalendar.setup(\n{");
        b.append("\n\t\tinputField : \"").append(targetId).append("\",");
        b.append("\n\t\tbutton : \"").append(this.triggerButton.getPath()).append("\",");
        String pattern = null;
        if (this.dateConverter == null) {
            ITypeConverter typeConverter;
            IConverter converter = this.target.getConverter();
            if (converter instanceof Converter && (typeConverter = ((Converter)converter).get(class$java$util$Date == null ? (class$java$util$Date = DatePicker.class$("java.util.Date")) : class$java$util$Date)) instanceof DateConverter) {
                this.dateConverter = (DateConverter)typeConverter;
            }
            if (this.dateConverter == null) {
                this.dateConverter = new DateConverter();
            }
        }
        if ((df = this.dateConverter.getDateFormat(this.target.getLocale())) instanceof SimpleDateFormat) {
            pattern = ((SimpleDateFormat)df).toPattern();
        }
        b.append(this.settings.toScript(this.target.getLocale(), pattern));
        int last = b.length() - 1;
        if (',' == b.charAt(last)) {
            b.deleteCharAt(last);
        }
        b.append("\n});");
        return b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class InitScript
    extends WebComponent {
        private static final long serialVersionUID = 1L;

        public InitScript(String id) {
            super(id);
        }

        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            this.replaceComponentTagBody(markupStream, openTag, DatePicker.this.getInitScript());
        }
    }

    private static final class TriggerButton
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public TriggerButton(String id, ResourceReference resourceReference) {
            super(id);
            this.add((IBehavior)new PathAttributeModifier("id", (Component)this));
            Model srcReplacement = new Model(this, resourceReference){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ ResourceReference val$resourceReference;
                private final /* synthetic */ TriggerButton this$0;
                {
                    this.this$0 = this$0;
                    this.val$resourceReference = val$resourceReference;
                }

                public Object getObject(Component component) {
                    return this.this$0.urlFor(this.val$resourceReference);
                }
            };
            this.add((IBehavior)new AttributeModifier("src", true, (IModel)srcReplacement));
        }
    }

    private static final class PathAttributeModifier
    extends AttributeModifier {
        private static final long serialVersionUID = 1L;

        public PathAttributeModifier(String attribute, Component pathProvider) {
            super(attribute, true, (IModel)new Model(pathProvider){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ Component val$pathProvider;
                {
                    this.val$pathProvider = val$pathProvider;
                }

                public Object getObject(Component component) {
                    if (this.val$pathProvider.getOutputMarkupId()) {
                        return this.val$pathProvider.getMarkupId();
                    }
                    return this.val$pathProvider.getPath();
                }
            });
        }
    }
}

