/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.form.palette;

import java.util.Collection;
import java.util.Iterator;
import wicket.AttributeModifier;
import wicket.Component;
import wicket.ResourceReference;
import wicket.behavior.IBehavior;
import wicket.extensions.markup.html.form.palette.component.Choices;
import wicket.extensions.markup.html.form.palette.component.Recorder;
import wicket.extensions.markup.html.form.palette.component.Selection;
import wicket.markup.ComponentTag;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.basic.Label;
import wicket.markup.html.form.IChoiceRenderer;
import wicket.markup.html.image.Image;
import wicket.markup.html.panel.Panel;
import wicket.model.AbstractModel;
import wicket.model.IModel;
import wicket.model.Model;

public class Palette
extends Panel {
    private static final String SELECTED_HEADER_ID = "selectedHeader";
    private static final String AVAILABLE_HEADER_ID = "availableHeader";
    private static final long serialVersionUID = 1L;
    private IModel choicesModel;
    private IChoiceRenderer choiceRenderer;
    private int rows;
    private Recorder recorderComponent;
    private Component choicesComponent;
    private Component selectionComponent;
    private static final ResourceReference javascript = new ResourceReference(class$wicket$extensions$markup$html$form$palette$Palette == null ? (class$wicket$extensions$markup$html$form$palette$Palette = Palette.class$("wicket.extensions.markup.html.form.palette.Palette")) : class$wicket$extensions$markup$html$form$palette$Palette, "palette.js");
    private static final ResourceReference upImage = new ResourceReference(class$wicket$extensions$markup$html$form$palette$Palette == null ? (class$wicket$extensions$markup$html$form$palette$Palette = Palette.class$("wicket.extensions.markup.html.form.palette.Palette")) : class$wicket$extensions$markup$html$form$palette$Palette, "up.gif");
    private static final ResourceReference downImage = new ResourceReference(class$wicket$extensions$markup$html$form$palette$Palette == null ? (class$wicket$extensions$markup$html$form$palette$Palette = Palette.class$("wicket.extensions.markup.html.form.palette.Palette")) : class$wicket$extensions$markup$html$form$palette$Palette, "down.gif");
    private static final ResourceReference removeImage = new ResourceReference(class$wicket$extensions$markup$html$form$palette$Palette == null ? (class$wicket$extensions$markup$html$form$palette$Palette = Palette.class$("wicket.extensions.markup.html.form.palette.Palette")) : class$wicket$extensions$markup$html$form$palette$Palette, "remove.gif");
    private static final ResourceReference addImage = new ResourceReference(class$wicket$extensions$markup$html$form$palette$Palette == null ? (class$wicket$extensions$markup$html$form$palette$Palette = Palette.class$("wicket.extensions.markup.html.form.palette.Palette")) : class$wicket$extensions$markup$html$form$palette$Palette, "add.gif");
    static /* synthetic */ Class class$wicket$extensions$markup$html$form$palette$Palette;

    public Palette(String id, IModel choicesModel, IChoiceRenderer choiceRenderer, int rows, boolean allowOrder) {
        this(id, null, choicesModel, choiceRenderer, rows, allowOrder);
    }

    public Palette(String id, IModel model, IModel choicesModel, IChoiceRenderer choiceRenderer, int rows, boolean allowOrder) {
        super(id, model);
        this.choicesModel = choicesModel;
        this.choiceRenderer = choiceRenderer;
        this.rows = rows;
        this.recorderComponent = this.newRecorderComponent();
        this.add((Component)this.recorderComponent);
        this.choicesComponent = this.newChoicesComponent();
        this.add(this.choicesComponent);
        this.selectionComponent = this.newSelectionComponent();
        this.add(this.selectionComponent);
        this.add(this.newAddComponent());
        this.add(this.newRemoveComponent());
        this.add(this.newUpComponent().setVisible(allowOrder));
        this.add(this.newDownComponent().setVisible(allowOrder));
        this.add(this.newAvailableHeader(AVAILABLE_HEADER_ID));
        this.add(this.newSelectedHeader(SELECTED_HEADER_ID));
        this.addJavascript();
    }

    private void addJavascript() {
        Model srcReplacement = new Model(){
            private static final long serialVersionUID = 1L;

            public Object getObject(Component component) {
                return Palette.this.urlFor(javascript);
            }
        };
        WebMarkupContainer javascript = new WebMarkupContainer("javascript");
        javascript.add((IBehavior)new AttributeModifier("src", true, (IModel)srcReplacement));
        this.add((Component)javascript);
    }

    public final boolean isPaletteEnabled() {
        return this.isEnabled() && this.isEnableAllowed();
    }

    public Iterator getSelectedChoices() {
        return this.getRecorderComponent().getSelectedChoices();
    }

    public Iterator getUnselectedChoices() {
        return this.getRecorderComponent().getUnselectedChoices();
    }

    private Recorder newRecorderComponent() {
        return new Recorder("recorder", this){
            private static final long serialVersionUID = 1L;

            public void updateModel() {
                super.updateModel();
                Palette.this.updateModel();
            }
        };
    }

    protected Component newAvailableHeader(String componentId) {
        return new Label(componentId, "Available");
    }

    protected Component newSelectedHeader(String componentId) {
        return new Label(componentId, "Selected");
    }

    protected Component newDownComponent() {
        return new PaletteButton("moveDownButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getDownOnClickJS());
            }
        }.add((Component)new Image("image", downImage));
    }

    protected Component newUpComponent() {
        return new PaletteButton("moveUpButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getUpOnClickJS());
            }
        }.add((Component)new Image("image", upImage));
    }

    protected Component newRemoveComponent() {
        return new PaletteButton("removeButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getRemoveOnClickJS());
            }
        }.add((Component)new Image("image", removeImage));
    }

    protected Component newAddComponent() {
        return new PaletteButton("addButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getAddOnClickJS());
            }
        }.add((Component)new Image("image", addImage));
    }

    protected Component newSelectionComponent() {
        return new Selection("selection", this);
    }

    protected Component newChoicesComponent() {
        return new Choices("choices", this);
    }

    private Component getChoicesComponent() {
        return this.choicesComponent;
    }

    private Component getSelectionComponent() {
        return this.selectionComponent;
    }

    public final Recorder getRecorderComponent() {
        return this.recorderComponent;
    }

    public Collection getChoices() {
        return (Collection)this.choicesModel.getObject((Component)this);
    }

    public Collection getModelCollection() {
        return (Collection)this.getModelObject();
    }

    public IChoiceRenderer getChoiceRenderer() {
        return this.choiceRenderer;
    }

    public int getRows() {
        return this.rows;
    }

    protected final void updateModel() {
        Collection model = (Collection)this.getModelObject();
        model.clear();
        Iterator it = this.getRecorderComponent().getSelectedChoices();
        while (it.hasNext()) {
            Object selectedChoice = it.next();
            model.add(selectedChoice);
        }
    }

    protected String buildJSCall(String funcName) {
        return funcName + "('" + this.getChoicesComponent().getMarkupId() + "','" + this.getSelectionComponent().getMarkupId() + "','" + this.getRecorderComponent().getMarkupId() + "');";
    }

    public String getChoicesOnFocusJS() {
        return this.buildJSCall("paletteChoicesOnFocus");
    }

    public String getSelectionOnFocusJS() {
        return this.buildJSCall("paletteSelectionOnFocus");
    }

    public String getAddOnClickJS() {
        return this.buildJSCall("paletteAdd");
    }

    public String getRemoveOnClickJS() {
        return this.buildJSCall("paletteRemove");
    }

    public String getUpOnClickJS() {
        return this.buildJSCall("paletteMoveUp");
    }

    public String getDownOnClickJS() {
        return this.buildJSCall("paletteMoveDown");
    }

    protected void internalOnDetach() {
        super.internalOnDetach();
        this.choicesModel.detach();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PassThroughModel
    extends AbstractModel {
        private static final long serialVersionUID = 1L;

        private PassThroughModel() {
        }

        public Object getObject(Component component) {
            return Palette.this.getModel().getObject((Component)Palette.this);
        }

        public void setObject(Component component, Object object) {
            Palette.this.getModel().setObject((Component)Palette.this, object);
        }
    }

    private class PaletteButton
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public PaletteButton(String id) {
            super(id);
        }

        protected void onComponentTag(ComponentTag tag) {
            if (!Palette.this.isPaletteEnabled()) {
                tag.getAttributes().put((Object)"disabled", (Object)"disabled");
            }
        }
    }
}

