/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.form.select;

import java.util.Collection;
import wicket.Component;
import wicket.WicketRuntimeException;
import wicket.extensions.markup.html.form.select.SelectOption;
import wicket.markup.html.form.FormComponent;
import wicket.model.IModel;
import wicket.util.lang.Objects;

public class Select
extends FormComponent {
    private static final long serialVersionUID = 1L;

    public Select(String id) {
        super(id);
    }

    public Select(String id, IModel model) {
        super(id, model);
    }

    public void updateModel() {
        Object object = this.getModelObject();
        boolean isModelCollection = object instanceof Collection;
        if (isModelCollection) {
            this.modelChanging();
            ((Collection)object).clear();
        } else {
            this.getModel().setObject((Component)this, null);
        }
        String[] paths = this.getInputAsArray();
        if (paths != null && paths.length > 0) {
            if (!isModelCollection && paths.length > 1) {
                throw new WicketRuntimeException("The model of Select component [" + this.getPath() + "] is not of type java.util.Collection, but more then one SelectOption component has been selected. Either remove the multiple attribute from the select tag or make the model of the Select component a collection");
            }
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path == null) continue;
                SelectOption option = (SelectOption)this.get(path = path.substring(this.getPath().length() + 1));
                if (option == null) {
                    throw new WicketRuntimeException("submitted http post value [" + paths.toString() + "] for SelectOption component [" + this.getPath() + "] contains an illegal relative path element [" + path + "] which does not point to an SelectOption component. Due to this the Select component cannot resolve the selected SelectOption component pointed to by the illegal value. A possible reason is that component hierarchy changed between rendering and form submission.");
                }
                if (isModelCollection) {
                    ((Collection)object).add(option.getModelObject());
                    continue;
                }
                this.setModelObject(option.getModelObject());
            }
        }
        if (isModelCollection) {
            this.modelChanged();
        }
    }

    boolean isSelected(SelectOption option) {
        if (this.hasRawInput()) {
            String[] paths = this.getInputAsArray();
            if (paths != null && paths.length > 0) {
                for (int i = 0; i < paths.length; ++i) {
                    String path = paths[i];
                    if (!path.equals(option.getPath())) continue;
                    return true;
                }
            }
        } else {
            Object selected = this.getModelObject();
            Object value = option.getModelObject();
            if (selected != null && selected instanceof Collection) {
                if (value instanceof Collection) {
                    return ((Collection)selected).containsAll((Collection)value);
                }
                return ((Collection)selected).contains(value);
            }
            return Objects.equal((Object)selected, (Object)value);
        }
        return false;
    }
}

