/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.form.select;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import wicket.Component;
import wicket.WicketRuntimeException;
import wicket.extensions.markup.html.form.select.IOptionRenderer;
import wicket.extensions.markup.html.form.select.SelectOption;
import wicket.extensions.markup.html.repeater.RepeatingView;
import wicket.markup.ComponentTag;
import wicket.markup.MarkupStream;
import wicket.markup.html.WebMarkupContainer;
import wicket.model.IModel;
import wicket.model.Model;

public class SelectOptions
extends RepeatingView {
    private static final long serialVersionUID = 1L;
    private boolean recreateChoices = false;
    private IOptionRenderer renderer;

    public SelectOptions(String id, IModel model, IOptionRenderer renderer) {
        super(id, model);
        this.renderer = renderer;
        this.setRenderBodyOnly(true);
    }

    public SelectOptions(String id, Collection elements, IOptionRenderer renderer) {
        this(id, (IModel)new Model((Serializable)((Object)elements)), renderer);
    }

    public SelectOptions setRecreateChoices(boolean refresh) {
        this.recreateChoices = refresh;
        return this;
    }

    protected void onBeginRequest() {
        if (this.size() == 0 || this.recreateChoices) {
            this.removeAll();
            Object modelObject = this.getModelObject();
            if (modelObject != null) {
                if (!(modelObject instanceof Collection)) {
                    throw new WicketRuntimeException("Model object " + modelObject + " not a collection");
                }
                Iterator it = ((Collection)modelObject).iterator();
                while (it.hasNext()) {
                    WebMarkupContainer row = new WebMarkupContainer(this.newChildId());
                    row.setRenderBodyOnly(true);
                    this.add((Component)row);
                    Object value = it.next();
                    String text = this.renderer.getDisplayValue(value);
                    IModel model = this.renderer.getModel(value);
                    row.add((Component)new SimpleSelectOption("option", model, text));
                }
            }
        }
    }

    private static class SimpleSelectOption
    extends SelectOption {
        private String text;
        private static final long serialVersionUID = 1L;

        public SimpleSelectOption(String id, IModel model, String text) {
            super(id, model);
            this.text = text;
        }

        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            this.replaceComponentTagBody(markupStream, openTag, this.text);
        }
    }
}

