/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data;

import java.util.Iterator;
import wicket.extensions.markup.html.repeater.data.IDataProvider;
import wicket.extensions.markup.html.repeater.pageable.AbstractPageableView;
import wicket.model.IDetachable;

public abstract class DataViewBase
extends AbstractPageableView {
    private IDataProvider dataProvider;

    public DataViewBase(String id, IDataProvider dataProvider) {
        super(id);
        if (dataProvider == null) {
            throw new IllegalArgumentException("argument [dataProvider] cannot be null");
        }
        this.dataProvider = dataProvider;
    }

    protected final IDataProvider internalGetDataProvider() {
        return this.dataProvider;
    }

    protected final Iterator getItemModels(int offset, int count) {
        return new ModelIterator(this.internalGetDataProvider(), offset, count);
    }

    protected final int internalGetItemCount() {
        return this.internalGetDataProvider().size();
    }

    protected void onDetach() {
        super.onDetach();
        if (this.dataProvider instanceof IDetachable) {
            ((IDetachable)this.dataProvider).detach();
        }
    }

    private static final class ModelIterator
    implements Iterator {
        private Iterator items;
        private IDataProvider dataProvider;
        private int max;
        private int index;

        public ModelIterator(IDataProvider dataProvider, int offset, int count) {
            this.items = dataProvider.iterator(offset, count);
            this.dataProvider = dataProvider;
            this.max = count;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.items.hasNext() && this.index < this.max;
        }

        public Object next() {
            ++this.index;
            return this.dataProvider.model(this.items.next());
        }
    }
}

