/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data;

import java.util.Iterator;
import wicket.Component;
import wicket.MarkupContainer;
import wicket.extensions.markup.html.repeater.RepeatingView;
import wicket.extensions.markup.html.repeater.data.DataViewBase;
import wicket.extensions.markup.html.repeater.data.IDataProvider;
import wicket.extensions.markup.html.repeater.refreshing.Item;
import wicket.version.undo.Change;

public abstract class GridView
extends DataViewBase {
    private int columns = 1;
    private int rows = Integer.MAX_VALUE;

    public GridView(String id, IDataProvider dataProvider) {
        super(id, dataProvider);
    }

    public int getColumns() {
        return this.columns;
    }

    public GridView setColumns(int cols) {
        if (cols < 1) {
            throw new IllegalArgumentException();
        }
        if (this.columns != cols) {
            if (this.isVersioned()) {
                this.addStateChange(new Change(){
                    private static final long serialVersionUID = 1L;
                    final int old;
                    {
                        this.old = GridView.this.columns;
                    }

                    public void undo() {
                        GridView.this.columns = this.old;
                    }

                    public String toString() {
                        return "GridViewColumnsChange[component: " + GridView.this.getPath() + ", removed columns: " + this.old + "]";
                    }
                });
            }
            this.columns = cols;
        }
        this.updateItemsPerPage();
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    public GridView setRows(int rows) {
        if (rows < 1) {
            throw new IllegalArgumentException();
        }
        if (this.rows != rows) {
            if (this.isVersioned()) {
                this.addStateChange(new Change(){
                    private static final long serialVersionUID = 1L;
                    final int old;
                    {
                        this.old = GridView.this.rows;
                    }

                    public void undo() {
                        GridView.this.rows = this.old;
                    }

                    public String toString() {
                        return "GridViewRowsChange[component: " + GridView.this.getPath() + ", removed rows: " + this.old + "]";
                    }
                });
            }
            this.rows = rows;
        }
        this.updateItemsPerPage();
        return this;
    }

    private void updateItemsPerPage() {
        int items = Integer.MAX_VALUE;
        long result = (long)this.rows * (long)this.columns;
        int desiredHiBits = -((int)(result >>> 31) & 1);
        int actualHiBits = (int)(result >>> 32);
        if (desiredHiBits == actualHiBits) {
            items = (int)result;
        }
        this.internalSetRowsPerPage(items);
    }

    protected void addItems(Iterator items) {
        if (items.hasNext()) {
            int cols = this.getColumns();
            int row = 0;
            do {
                Item rowItem = this.newRowItem(this.newChildId(), row);
                RepeatingView rowView = new RepeatingView("cols");
                rowItem.add((Component)rowView);
                this.add((Component)rowItem);
                for (int index = 0; index < cols; ++index) {
                    Item cellItem;
                    if (items.hasNext()) {
                        cellItem = (Item)((Object)items.next());
                    } else {
                        cellItem = this.newEmptyItem(this.newChildId(), index);
                        this.populateEmptyItem(cellItem);
                    }
                    rowView.add((Component)cellItem);
                }
                ++row;
            } while (items.hasNext());
        }
    }

    public IDataProvider getDataProvider() {
        return this.internalGetDataProvider();
    }

    public Iterator getItems() {
        return new ItemsIterator(this.iterator());
    }

    protected abstract void populateEmptyItem(Item var1);

    protected Item newEmptyItem(String id, int index) {
        return new Item(id, index, null);
    }

    protected Item newRowItem(String id, int index) {
        return new Item(id, index, null);
    }

    private static class ItemsIterator
    implements Iterator {
        private Iterator rows;
        private Iterator cells;
        private Item next;

        public ItemsIterator(Iterator rows) {
            this.rows = rows;
            this.findNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Item item = this.next;
            this.findNext();
            return item;
        }

        private void findNext() {
            this.next = null;
            if (this.cells != null && this.cells.hasNext()) {
                this.next = (Item)((Object)this.cells.next());
            }
            while (this.rows.hasNext()) {
                MarkupContainer row = (MarkupContainer)this.rows.next();
                this.cells = ((MarkupContainer)row.iterator().next()).iterator();
                if (!this.cells.hasNext()) continue;
                this.next = (Item)((Object)this.cells.next());
                break;
            }
        }
    }
}

