/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data.grid;

import java.io.Serializable;
import java.util.Iterator;
import wicket.Component;
import wicket.WicketRuntimeException;
import wicket.extensions.markup.html.repeater.data.DataViewBase;
import wicket.extensions.markup.html.repeater.data.IDataProvider;
import wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import wicket.extensions.markup.html.repeater.refreshing.Item;
import wicket.extensions.markup.html.repeater.refreshing.RefreshingView;
import wicket.extensions.markup.html.repeater.util.ArrayIteratorAdapter;
import wicket.model.IModel;
import wicket.model.Model;

public abstract class AbstractDataGridView
extends DataViewBase {
    private static final long serialVersionUID = 1L;
    private static final String CELL_REPEATER_ID = "cells";
    private static final String CELL_ITEM_ID = "cell";
    private ICellPopulator[] populators;
    private transient ArrayIteratorAdapter populatorsIteratorCache;

    public AbstractDataGridView(String id, ICellPopulator[] populators, IDataProvider dataProvider) {
        super(id, dataProvider);
        this.populators = populators;
    }

    private Iterator getPopulatorsIterator() {
        if (this.populatorsIteratorCache == null) {
            this.populatorsIteratorCache = new ArrayIteratorAdapter(this.internalGetPopulators()){

                protected IModel model(Object object) {
                    return new Model((Serializable)object);
                }
            };
        } else {
            this.populatorsIteratorCache.reset();
        }
        return this.populatorsIteratorCache;
    }

    protected final void populateItem(Item item) {
        final IModel rowModel = item.getModel();
        item.add((Component)new RefreshingView(CELL_REPEATER_ID){
            private static final long serialVersionUID = 1L;

            protected Iterator getItemModels() {
                return AbstractDataGridView.this.getPopulatorsIterator();
            }

            protected void populateItem(Item item) {
                ICellPopulator populator = (ICellPopulator)item.getModelObject();
                populator.populateItem(item, AbstractDataGridView.CELL_ITEM_ID, rowModel);
                if (item.get(AbstractDataGridView.CELL_ITEM_ID) == null) {
                    throw new WicketRuntimeException(populator.getClass().getName() + ".populateItem() failed to add a component with id [" + AbstractDataGridView.CELL_ITEM_ID + "] to the provided [cellItem] object. Make sure you call add() on cellItem ( cellItem.add(new MyComponent(componentId, rowModel) )");
                }
            }

            protected Item newItem(String id, int index, IModel model) {
                return AbstractDataGridView.this.newCellItem(id, index, model);
            }
        });
    }

    protected final ICellPopulator[] internalGetPopulators() {
        return this.populators;
    }

    protected final Item newItem(String id, int index, IModel model) {
        return this.newRowItem(id, index, model);
    }

    protected Item newRowItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }

    protected Item newCellItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }
}

