/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data.table;

import wicket.Component;
import wicket.extensions.markup.html.repeater.RepeatingView;
import wicket.extensions.markup.html.repeater.data.IDataProvider;
import wicket.extensions.markup.html.repeater.data.grid.DataGridView;
import wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import wicket.extensions.markup.html.repeater.data.table.IColumn;
import wicket.extensions.markup.html.repeater.refreshing.IItemReuseStrategy;
import wicket.extensions.markup.html.repeater.refreshing.Item;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.navigation.paging.IPageable;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;

public class DataTable
extends Panel
implements IPageable {
    public static final String TOOLBAR_COMPONENT_ID = "toolbar";
    private static final long serialVersionUID = 1L;
    private final DataGridView datagrid;
    private IColumn[] columns;
    private final RepeatingView topToolbars;
    private final RepeatingView bottomToolbars;

    public DataTable(String id, IColumn[] columns, IDataProvider dataProvider, int rowsPerPage) {
        super(id);
        this.columns = columns;
        this.datagrid = new DataGridView("rows", columns, dataProvider){
            private static final long serialVersionUID = 1L;

            protected Item newRowItem(String id, int index, IModel model) {
                return DataTable.this.newRowItem(id, index, model);
            }

            protected Item newCellItem(String id, int index, IModel model) {
                return DataTable.this.newCellItem(id, index, model);
            }
        };
        this.datagrid.setRowsPerPage(rowsPerPage);
        this.add((Component)this.datagrid);
        this.topToolbars = new RepeatingView("topToolbars"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return this.size() > 0;
            }
        };
        this.bottomToolbars = new RepeatingView("bottomToolbars"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return this.size() > 0;
            }
        };
        this.add((Component)this.topToolbars);
        this.add((Component)this.bottomToolbars);
    }

    public final IColumn[] getColumns() {
        return this.columns;
    }

    public void addTopToolbar(AbstractToolbar toolbar) {
        this.addToolbar(toolbar, this.topToolbars);
    }

    public void addBottomToolbar(AbstractToolbar toolbar) {
        this.addToolbar(toolbar, this.bottomToolbars);
    }

    private void addToolbar(AbstractToolbar toolbar, RepeatingView container) {
        if (toolbar == null) {
            throw new IllegalArgumentException("argument [toolbar] cannot be null");
        }
        if (!toolbar.getId().equals(TOOLBAR_COMPONENT_ID)) {
            throw new IllegalArgumentException("Toolbar must have component id equal to AbstractDataTable.TOOLBAR_COMPONENT_ID");
        }
        toolbar.setRenderBodyOnly(true);
        WebMarkupContainer item = new WebMarkupContainer(container.newChildId());
        item.setRenderBodyOnly(true);
        item.add((Component)toolbar);
        container.add((Component)item);
    }

    public final int getCurrentPage() {
        return this.datagrid.getCurrentPage();
    }

    public final void setCurrentPage(int page) {
        this.datagrid.setCurrentPage(page);
        this.onPageChanged();
    }

    protected void onPageChanged() {
    }

    public final int getPageCount() {
        return this.datagrid.getPageCount();
    }

    public final int getRowCount() {
        return this.datagrid.getRowCount();
    }

    public void setRowsPerPage(int items) {
        this.datagrid.setRowsPerPage(items);
    }

    public final int getRowsPerPage() {
        return this.datagrid.getRowsPerPage();
    }

    protected Item newRowItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }

    protected Item newCellItem(String id, int index, IModel model) {
        return new Item(id, index, model);
    }

    public final DataTable setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.datagrid.setItemReuseStrategy(strategy);
        return this;
    }
}

