/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data.table;

import wicket.Component;
import wicket.extensions.markup.html.repeater.RepeatingView;
import wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import wicket.extensions.markup.html.repeater.data.table.DataTable;
import wicket.extensions.markup.html.repeater.data.table.IColumn;
import wicket.markup.html.WebMarkupContainer;

public class HeadersToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public HeadersToolbar(DataTable table, ISortStateLocator stateLocator) {
        super(table);
        RepeatingView headers = new RepeatingView("headers");
        this.add((Component)headers);
        IColumn[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            IColumn column = columns[i];
            WebMarkupContainer item = new WebMarkupContainer(headers.newChildId());
            headers.add((Component)item);
            WebMarkupContainer header = null;
            header = column.isSortable() ? this.newSortableHeader("header", column.getSortProperty(), stateLocator) : new WebMarkupContainer("header");
            item.add((Component)header);
            item.setRenderBodyOnly(true);
            header.add(column.getHeader("label"));
        }
    }

    protected WebMarkupContainer newSortableHeader(String headerId, String property, ISortStateLocator locator) {
        return new OrderByBorder(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            protected void onSortChanged() {
                HeadersToolbar.this.getTable().setCurrentPage(0);
            }
        };
    }
}

