/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data.table.filter;

import wicket.Component;
import wicket.behavior.AbstractBehavior;
import wicket.behavior.IBehavior;
import wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import wicket.markup.ComponentTag;
import wicket.markup.html.form.Form;
import wicket.markup.html.form.FormComponent;
import wicket.markup.html.form.HiddenField;
import wicket.model.AbstractModel;
import wicket.model.IModel;
import wicket.model.Model;

public class FilterForm
extends Form {
    private static final long serialVersionUID = 1L;
    private final HiddenField hidden;
    private final IFilterStateLocator locator;

    public FilterForm(String id, IFilterStateLocator locator) {
        super(id, (IModel)new FilterStateModel(locator));
        this.locator = locator;
        this.hidden = new HiddenField("focus-tracker", (IModel)new Model());
        this.hidden.add((IBehavior)new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("id", (CharSequence)FilterForm.this.getFocusTrackerFieldCssId());
                super.onComponentTag(component, tag);
            }
        });
        this.add((Component)this.hidden);
    }

    public final String getFocusTrackerFieldCssId() {
        return this.hidden.getPageRelativePath();
    }

    public final IFilterStateLocator getStateLocator() {
        return this.locator;
    }

    public final void enableFocusTracking(FormComponent fc) {
        fc.add((IBehavior)new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("id", (CharSequence)component.getPageRelativePath());
                tag.put("onfocus", (CharSequence)FilterForm.this.getFocusTrackingHandler(component));
                super.onComponentTag(component, tag);
            }
        });
    }

    public final String getFocusTrackingHandler(Component component) {
        return "_filter_focus(this, '" + this.getFocusTrackerFieldCssId() + "');";
    }

    private static class FilterStateModel
    extends AbstractModel {
        private static final long serialVersionUID = 1L;
        private IFilterStateLocator locator;

        public FilterStateModel(IFilterStateLocator locator) {
            if (locator == null) {
                throw new IllegalArgumentException("argument [locator] cannot be null");
            }
            this.locator = locator;
        }

        public IModel getNestedModel() {
            return null;
        }

        public Object getObject(Component component) {
            return this.locator.getFilterState();
        }

        public void setObject(Component component, Object object) {
            this.locator.setFilterState(object);
        }
    }
}

