/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.data.table.filter;

import wicket.Component;
import wicket.extensions.markup.html.repeater.RepeatingView;
import wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import wicket.extensions.markup.html.repeater.data.table.DataTable;
import wicket.extensions.markup.html.repeater.data.table.IColumn;
import wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import wicket.extensions.markup.html.repeater.data.table.filter.IFilteredColumn;
import wicket.extensions.markup.html.repeater.data.table.filter.NoFilter;
import wicket.markup.ComponentTag;
import wicket.markup.MarkupStream;
import wicket.markup.html.WebMarkupContainer;
import wicket.util.string.AppendingStringBuffer;

public class FilterToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_COMPONENT_ID = "filter";

    public FilterToolbar(final DataTable table, IFilterStateLocator stateLocator) {
        super(table);
        if (table == null) {
            throw new IllegalArgumentException("argument [table] cannot be null");
        }
        if (stateLocator == null) {
            throw new IllegalArgumentException("argument [stateLocator] cannot be null");
        }
        final FilterForm form = new FilterForm("filter-form", stateLocator){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                table.setCurrentPage(0);
            }
        };
        this.add((Component)form);
        this.add((Component)new WebMarkupContainer("focus-restore"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                AppendingStringBuffer script = new AppendingStringBuffer((CharSequence)"<script>_filter_focus_restore('").append(form.getFocusTrackerFieldCssId()).append("');</script>");
                this.replaceComponentTagBody(markupStream, openTag, (CharSequence)script);
            }
        });
        RepeatingView filters = new RepeatingView("filters");
        form.add((Component)filters);
        IColumn[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            WebMarkupContainer item = new WebMarkupContainer(filters.newChildId());
            item.setRenderBodyOnly(true);
            IColumn col = cols[i];
            NoFilter filter = null;
            if (col instanceof IFilteredColumn) {
                IFilteredColumn filteredCol = (IFilteredColumn)col;
                filter = filteredCol.getFilter(FILTER_COMPONENT_ID, form);
            }
            if (filter == null) {
                filter = new NoFilter(FILTER_COMPONENT_ID);
            } else if (!filter.getId().equals(FILTER_COMPONENT_ID)) {
                throw new IllegalStateException("filter component returned  with an invalid component id. invalid component id [" + filter.getId() + "] required component id [" + FILTER_COMPONENT_ID + "] generating column [" + col.toString() + "] ");
            }
            item.add((Component)filter);
            filters.add((Component)item);
        }
    }
}

