/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.pageable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import wicket.extensions.markup.html.repeater.refreshing.RefreshingView;
import wicket.markup.html.navigation.paging.IPageable;
import wicket.model.IModel;
import wicket.version.undo.Change;

public abstract class AbstractPageableView
extends RefreshingView
implements IPageable {
    private int itemsPerPage = Integer.MAX_VALUE;
    private int currentPage;
    private int cachedItemCount;

    public AbstractPageableView(String id, IModel model) {
        super(id, model);
        this.clearCachedItemCount();
    }

    public AbstractPageableView(String id) {
        super(id);
        this.clearCachedItemCount();
    }

    protected Iterator getItemModels() {
        int offset = this.getViewOffset();
        int size = this.getViewSize();
        Iterator models = this.getItemModels(offset, size);
        models = new CappedIteratorAdapter(models, size);
        return models;
    }

    protected void internalOnDetach() {
        super.internalOnDetach();
        this.clearCachedItemCount();
    }

    protected abstract Iterator getItemModels(int var1, int var2);

    private void clearCachedItemCount() {
        this.cachedItemCount = -1;
    }

    private void setCachedItemCount(int itemCount) {
        this.cachedItemCount = itemCount;
    }

    private int getCachedItemCount() {
        if (this.cachedItemCount < 0) {
            throw new IllegalStateException("getItemCountCache() called when cache was not set");
        }
        return this.cachedItemCount;
    }

    private boolean isItemCountCached() {
        return this.cachedItemCount >= 0;
    }

    protected final int internalGetRowsPerPage() {
        return this.itemsPerPage;
    }

    protected final void internalSetRowsPerPage(int items) {
        if (items < 1) {
            throw new IllegalArgumentException("Argument [itemsPerPage] cannot be less then 1");
        }
        if (this.itemsPerPage != items && this.isVersioned()) {
            this.addStateChange(new Change(){
                private static final long serialVersionUID = 1L;
                final int old;
                {
                    this.old = AbstractPageableView.this.itemsPerPage;
                }

                public void undo() {
                    AbstractPageableView.this.itemsPerPage = this.old;
                }

                public String toString() {
                    return "ItemsPerPageChange[component: " + AbstractPageableView.this.getPath() + ", itemsPerPage: " + this.old + "]";
                }
            });
        }
        this.itemsPerPage = items;
        this.setCurrentPage(0);
    }

    protected abstract int internalGetItemCount();

    public final int getRowCount() {
        if (!this.isVisibleInHierarchy()) {
            return 0;
        }
        if (this.isItemCountCached()) {
            return this.getCachedItemCount();
        }
        int count = this.internalGetItemCount();
        this.setCachedItemCount(count);
        return count;
    }

    public final int getCurrentPage() {
        int page = this.currentPage;
        if (page >= this.getPageCount()) {
            page = Math.max(this.getPageCount() - 1, 0);
            this.setCurrentPage(page);
            return page;
        }
        return page;
    }

    public final void setCurrentPage(int page) {
        if (page < 0 || page >= this.getPageCount() && this.getPageCount() > 0) {
            throw new IndexOutOfBoundsException("argument [page]=" + page + ", must be 0<=page<" + this.getPageCount());
        }
        if (this.currentPage != page && this.isVersioned()) {
            this.addStateChange(new Change(){
                private static final long serialVersionUID = 1L;
                private final int old;
                {
                    this.old = AbstractPageableView.this.currentPage;
                }

                public void undo() {
                    AbstractPageableView.this.currentPage = this.old;
                }

                public String toString() {
                    return "CurrentPageChange[component: " + AbstractPageableView.this.getPath() + ", currentPage: " + this.old + "]";
                }
            });
        }
        this.currentPage = page;
    }

    public final int getPageCount() {
        int count;
        int total = this.getRowCount();
        int page = this.internalGetRowsPerPage();
        if (page * (count = total / page) < total) {
            ++count;
        }
        return count;
    }

    protected int getViewOffset() {
        return this.getCurrentPage() * this.internalGetRowsPerPage();
    }

    protected int getViewSize() {
        return Math.min(this.internalGetRowsPerPage(), this.getRowCount() - this.getViewOffset());
    }

    private static class CappedIteratorAdapter
    implements Iterator {
        private int max;
        private int index;
        private Iterator delegate;

        public CappedIteratorAdapter(Iterator delegate, int max) {
            this.delegate = delegate;
            this.max = max;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.max && this.delegate.hasNext();
        }

        public Object next() {
            if (this.index >= this.max) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.delegate.next();
        }
    }
}

