/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.repeater.refreshing;

import java.util.Comparator;
import wicket.markup.html.WebMarkupContainer;
import wicket.model.IModel;
import wicket.version.undo.Change;

public class Item
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private int index;

    public Item(String id, int index, IModel model) {
        super(id, model);
        this.index = index;
    }

    public void setIndex(int index) {
        if (this.index != index) {
            if (this.isVersioned()) {
                this.addStateChange(new Change(){
                    final int oldIndex;
                    private static final long serialVersionUID = 1L;
                    {
                        this.oldIndex = Item.this.index;
                    }

                    public void undo() {
                        Item.this.index = this.oldIndex;
                    }

                    public String toString() {
                        return "IndexChange[component: " + Item.this.getPath() + ", index: " + this.oldIndex + "]";
                    }
                });
            }
            this.index = index;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getPrimaryKey() {
        return this.getId();
    }

    public static class IndexComparator
    implements Comparator {
        private static final Comparator instance = new IndexComparator();

        public static final Comparator getInstance() {
            return instance;
        }

        public int compare(Object o1, Object o2) {
            Item lhs = (Item)((Object)o1);
            Item rhs = (Item)((Object)o2);
            return lhs.getIndex() - rhs.getIndex();
        }
    }
}

