/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tabs;

import java.io.Serializable;
import java.util.List;
import wicket.Component;
import wicket.WicketRuntimeException;
import wicket.behavior.AttributeAppender;
import wicket.behavior.IBehavior;
import wicket.behavior.SimpleAttributeModifier;
import wicket.extensions.markup.html.tabs.ITab;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.basic.Label;
import wicket.markup.html.link.Link;
import wicket.markup.html.list.Loop;
import wicket.markup.html.panel.Panel;
import wicket.model.AbstractReadOnlyModel;
import wicket.model.IModel;
import wicket.model.Model;

public class TabbedPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String TAB_PANEL_ID = "panel";
    private List tabs;

    public TabbedPanel(String id, List tabs) {
        super(id, (IModel)new Model((Serializable)new Integer(-1)));
        if (tabs == null) {
            throw new IllegalArgumentException("argument [tabs] cannot be null");
        }
        if (tabs.size() < 1) {
            throw new IllegalArgumentException("argument [tabs] must contain a list of at least one tab");
        }
        this.tabs = tabs;
        AbstractReadOnlyModel tabCount = new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject(Component component) {
                return new Integer(TabbedPanel.this.tabs.size());
            }
        };
        this.add((Component)new Loop("tabs", (IModel)tabCount){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Loop.LoopItem item) {
                int index = item.getIteration();
                ITab tab = (ITab)TabbedPanel.this.tabs.get(index);
                int selected = TabbedPanel.this.getSelectedTab();
                WebMarkupContainer titleLink = TabbedPanel.this.newLink("link", index);
                titleLink.add((Component)new Label("title", tab.getTitle()));
                item.add((Component)titleLink);
                item.add((IBehavior)new SimpleAttributeModifier(this, "class", "selected", index, selected){
                    private static final long serialVersionUID = 1L;
                    private final /* synthetic */ int val$index;
                    private final /* synthetic */ int val$selected;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$index = val$index;
                        this.val$selected = val$selected;
                    }

                    public boolean isEnabled() {
                        return this.val$index == this.val$selected;
                    }
                });
                if (item.getIteration() == this.getIterations() - 1) {
                    item.add((IBehavior)new AttributeAppender("class", true, (IModel)new Model((Serializable)((Object)"last")), " "));
                }
            }
        });
        this.setSelectedTab(0);
    }

    public final List getTabs() {
        return this.tabs;
    }

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new Link(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                TabbedPanel.this.setSelectedTab(index);
            }
        };
    }

    public final void setSelectedTab(int index) {
        if (index < 0 || index >= this.tabs.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setModelObject(new Integer(index));
        ITab tab = (ITab)this.tabs.get(index);
        Panel panel = tab.getPanel(TAB_PANEL_ID);
        if (panel == null) {
            throw new WicketRuntimeException("ITab.getPanel() returned null. TabbedPanel [" + this.getPath() + "] ITab index [" + index + "]");
        }
        if (!panel.getId().equals(TAB_PANEL_ID)) {
            throw new WicketRuntimeException("ITab.getPanel() returned a panel with invalid id [" + panel.getId() + "]. You must always return a panel with id equal to the provided panelId parameter. TabbedPanel [" + this.getPath() + "] ITab index [" + index + "]");
        }
        if (this.get(TAB_PANEL_ID) == null) {
            this.add((Component)panel);
        } else {
            this.replace((Component)panel);
        }
    }

    public final int getSelectedTab() {
        return (Integer)this.getModelObject();
    }
}

