/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import wicket.Component;
import wicket.ajax.AjaxRequestTarget;
import wicket.behavior.HeaderContributor;
import wicket.behavior.IBehavior;
import wicket.extensions.markup.html.tree.AbstractTree;
import wicket.extensions.markup.html.tree.DefaultTreeState;
import wicket.extensions.markup.html.tree.ITreeState;
import wicket.extensions.markup.html.tree.ITreeStateListener;
import wicket.markup.MarkupStream;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.panel.Panel;
import wicket.model.IDetachable;
import wicket.model.IModel;
import wicket.model.Model;
import wicket.util.string.AppendingStringBuffer;

public abstract class AbstractTree
extends Panel
implements ITreeStateListener,
TreeModelListener {
    private boolean attached = false;
    private final AppendingStringBuffer deleteIds = new AppendingStringBuffer();
    private boolean dirtyAll = false;
    private final List dirtyItems = new ArrayList();
    private final List dirtyItemsCreateDOM = new ArrayList();
    private int idCounter = 0;
    private TreeItemContainer itemContainer;
    private final Map nodeToItemMap = new HashMap();
    private TreeModel previousModel = null;
    private TreeItem rootItem = null;
    private boolean rootLess = false;
    private ITreeState state;
    static /* synthetic */ Class class$wicket$extensions$markup$html$tree$AbstractTree;

    private static final Iterator toIterator(Enumeration enumeration) {
        return new Iterator(enumeration){
            private Enumeration e;
            private final /* synthetic */ Enumeration val$enumeration;
            {
                this.e = this.val$enumeration = val$enumeration;
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object next() {
                return this.e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported on enumeration.");
            }
        };
    }

    public AbstractTree(String id) {
        super(id);
        this.init();
    }

    public AbstractTree(String id, IModel model) {
        super(id, model);
        this.init();
    }

    public final void allNodesCollapsed() {
        this.invalidateAll();
    }

    public final void allNodesExpanded() {
        this.invalidateAll();
    }

    public ITreeState getTreeState() {
        if (this.state == null) {
            this.state = this.newTreeState();
            this.state.addTreeStateListener(this);
        }
        return this.state;
    }

    protected void onBeforeAttach() {
    }

    public void internalAttach() {
        if (!this.attached) {
            TreeNode rootNode;
            this.onBeforeAttach();
            this.checkModel();
            if (this.dirtyAll && this.rootItem != null) {
                this.clearAllItem();
            } else {
                this.rebuildDirty();
            }
            if (this.rootItem == null && (rootNode = (TreeNode)((TreeModel)this.getModelObject()).getRoot()) != null) {
                this.rootItem = this.isRootLess() ? this.newTreeItem(rootNode, -1) : this.newTreeItem(rootNode, 0);
                this.itemContainer.add((Component)this.rootItem);
                this.buildItemChildren(this.rootItem);
            }
            this.attached = true;
        }
        super.internalAttach();
    }

    public void internalDetach() {
        super.internalDetach();
        this.attached = false;
    }

    public final void invalidateAll() {
        this.updated();
        this.dirtyAll = true;
    }

    public final boolean isRootLess() {
        return this.rootLess;
    }

    public final void nodeCollapsed(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNodeWithChildren(node);
        }
    }

    public final void nodeExpanded(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNodeWithChildren(node);
        }
    }

    public final void nodeSelected(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNode(node, true);
        }
    }

    public final void nodeUnselected(TreeNode node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNode(node, true);
        }
    }

    public void setRootLess(boolean rootLess) {
        if (this.rootLess != rootLess) {
            this.rootLess = rootLess;
            this.invalidateAll();
            if (rootLess && this.getModelObject() != null) {
                this.getTreeState().expandNode((TreeNode)((TreeModel)this.getModelObject()).getRoot());
            }
        }
    }

    public final void treeNodesChanged(TreeModelEvent e) {
        if (e.getChildren() == null) {
            if (this.rootItem != null) {
                this.invalidateNode((TreeNode)this.rootItem.getModelObject(), true);
            }
        } else {
            Object[] children = e.getChildren();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    TreeNode node = (TreeNode)children[i];
                    if (!this.isNodeVisible(node)) continue;
                    this.invalidateNode(node, true);
                }
            }
        }
    }

    private void markTheLastButOneChildDirty(TreeItem parent, TreeItem child) {
        if (parent.getChildren().indexOf((Object)child) == parent.getChildren().size() - 1) {
            for (int i = parent.getChildren().size() - 2; i >= 0; --i) {
                TreeItem item = (TreeItem)((Object)parent.getChildren().get(i));
                this.invalidateNodeWithChildren((TreeNode)item.getModelObject());
            }
        }
    }

    public final void treeNodesInserted(TreeModelEvent e) {
        TreeNode parent = (TreeNode)e.getTreePath().getLastPathComponent();
        if (this.isNodeVisible(parent) && this.isNodeExpanded(parent)) {
            TreeItem parentItem = (TreeItem)((Object)this.nodeToItemMap.get(parent));
            for (int i = 0; i < e.getChildren().length; ++i) {
                TreeNode node = (TreeNode)e.getChildren()[i];
                int index = e.getChildIndices()[i];
                TreeItem item = this.newTreeItem(node, parentItem.getLevel() + 1);
                this.itemContainer.add((Component)item);
                parentItem.getChildren().add(index, item);
                this.markTheLastButOneChildDirty(parentItem, item);
                this.dirtyItems.add(item);
                this.dirtyItemsCreateDOM.add(item);
            }
        }
    }

    public final void treeNodesRemoved(TreeModelEvent e) {
        TreeNode parent = (TreeNode)e.getTreePath().getLastPathComponent();
        TreeItem parentItem = (TreeItem)((Object)this.nodeToItemMap.get(parent));
        if (this.isNodeVisible(parent) && this.isNodeExpanded(parent)) {
            for (int i = 0; i < e.getChildren().length; ++i) {
                TreeNode node = (TreeNode)e.getChildren()[i];
                TreeItem item = (TreeItem)((Object)this.nodeToItemMap.get(node));
                if (item == null) continue;
                this.markTheLastButOneChildDirty(parentItem, item);
                parentItem.getChildren().remove((Object)item);
                this.visitItemChildren(item, new IItemCallback(){

                    public void visitItem(TreeItem item) {
                        AbstractTree.this.removeItem(item);
                        AbstractTree.this.getTreeState().selectNode((TreeNode)item.getModelObject(), false);
                    }
                });
                this.removeItem(item);
            }
        }
    }

    public final void treeStructureChanged(TreeModelEvent e) {
        TreeNode node = (TreeNode)e.getTreePath().getLastPathComponent();
        if (e.getTreePath().getPathCount() == 1 && node.equals(this.rootItem.getModelObject())) {
            this.invalidateAll();
        } else {
            this.invalidateNodeWithChildren(node);
        }
    }

    public final void updateTree(AjaxRequestTarget target) {
        if (target == null) {
            return;
        }
        this.checkModel();
        if (this.dirtyAll) {
            target.addComponent((Component)this);
        } else {
            TreeItem item;
            Iterator i;
            if (this.deleteIds.length() != 0) {
                String js = this.getElementsDeleteJavascript();
                target.prependJavascript(js);
            }
            while (!this.dirtyItemsCreateDOM.isEmpty()) {
                i = this.dirtyItemsCreateDOM.iterator();
                while (i.hasNext()) {
                    TreeItem previous;
                    item = (TreeItem)((Object)i.next());
                    TreeItem parent = item.getParentItem();
                    int index = parent.getChildren().indexOf((Object)item);
                    if (index == 0) {
                        previous = parent;
                    } else {
                        previous = (TreeItem)((Object)parent.getChildren().get(index - 1));
                        while (previous.getChildren() != null && previous.getChildren().size() > 0) {
                            previous = (TreeItem)((Object)previous.getChildren().get(previous.getChildren().size() - 1));
                        }
                    }
                    if (this.dirtyItemsCreateDOM.contains((Object)previous)) continue;
                    target.prependJavascript("Wicket.Tree.createElement(\"" + item.getMarkupId() + "\"," + "\"" + previous.getMarkupId() + "\")");
                    i.remove();
                }
            }
            i = this.dirtyItems.iterator();
            while (i.hasNext()) {
                item = (TreeItem)((Object)i.next());
                if (item.getChildren() == null) {
                    this.buildItemChildren(item);
                    item.setRenderChildren(true);
                }
                target.addComponent((Component)item);
            }
            this.updated();
        }
    }

    protected final boolean isNodeExpanded(TreeNode node) {
        if (this.isRootLess() && this.rootItem != null && this.rootItem.getModelObject().equals(node)) {
            return true;
        }
        return this.getTreeState().isNodeExpanded(node);
    }

    protected ITreeState newTreeState() {
        return new DefaultTreeState();
    }

    protected void onAfterRender() {
        this.updated();
    }

    protected abstract void populateTreeItem(WebMarkupContainer var1, int var2);

    private final void buildItemChildren(TreeItem item) {
        List items = this.isNodeExpanded((TreeNode)item.getModelObject()) ? this.buildTreeItems(this.nodeChildren((TreeNode)item.getModelObject()), item.getLevel() + 1) : Collections.EMPTY_LIST;
        item.setChildren(items);
    }

    private final List buildTreeItems(Iterator nodes, int level) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            TreeItem item = this.newTreeItem(node, level);
            this.itemContainer.add((Component)item);
            this.buildItemChildren(item);
            result.add(item);
        }
        return result;
    }

    private final void checkModel() {
        TreeModel model = (TreeModel)this.getModelObject();
        if (model != this.previousModel) {
            if (this.previousModel != null) {
                this.previousModel.removeTreeModelListener(this);
            }
            this.previousModel = model;
            if (model != null) {
                model.addTreeModelListener(this);
            }
            this.invalidateAll();
        }
    }

    private final void clearAllItem() {
        this.visitItemAndChildren(this.rootItem, new IItemCallback(){

            public void visitItem(TreeItem item) {
                item.remove();
            }
        });
        this.rootItem = null;
    }

    private String getElementsDeleteJavascript() {
        AppendingStringBuffer buffer = new AppendingStringBuffer(100);
        buffer.append("Wicket.Tree.removeNodes(\"");
        buffer.append(this.getMarkupId() + "_\",[");
        buffer.append(this.deleteIds);
        if (buffer.endsWith((CharSequence)",")) {
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append("]);");
        return buffer.toString();
    }

    private String getShortItemId(TreeItem item) {
        int skip = this.getMarkupId().length() + 1;
        return item.getMarkupId().substring(skip);
    }

    private final void init() {
        this.setVersioned(false);
        this.setOutputMarkupId(true);
        this.itemContainer = new TreeItemContainer("i");
        this.add((Component)this.itemContainer);
        this.add((IBehavior)HeaderContributor.forJavaScript((Class)(class$wicket$extensions$markup$html$tree$AbstractTree == null ? (class$wicket$extensions$markup$html$tree$AbstractTree = AbstractTree.class$("wicket.extensions.markup.html.tree.AbstractTree")) : class$wicket$extensions$markup$html$tree$AbstractTree), (String)"res/tree.js"));
    }

    private final void invalidateNode(TreeNode node, boolean forceRebuild) {
        TreeItem item;
        if (!this.dirtyAll && (item = (TreeItem)((Object)this.nodeToItemMap.get(node))) != null) {
            boolean createDOM = false;
            if (forceRebuild) {
                int level = item.getLevel();
                List children = item.getChildren();
                String id = item.getId();
                TreeItem parent = item.getParentItem();
                int index = parent != null ? parent.getChildren().indexOf((Object)item) : -1;
                createDOM = this.dirtyItemsCreateDOM.contains((Object)item);
                this.dirtyItems.remove((Object)item);
                this.dirtyItemsCreateDOM.remove((Object)item);
                item.remove();
                item = this.newTreeItem(node, level, id);
                this.itemContainer.add((Component)item);
                item.setChildren(children);
                if (parent == null) {
                    this.rootItem = item;
                } else {
                    parent.getChildren().set(index, item);
                }
            }
            this.dirtyItems.add(item);
            if (createDOM) {
                this.dirtyItemsCreateDOM.add(item);
            }
        }
    }

    private final void invalidateNodeWithChildren(TreeNode node) {
        TreeItem item;
        if (!this.dirtyAll && (item = (TreeItem)((Object)this.nodeToItemMap.get(node))) != null) {
            this.visitItemChildren(item, new IItemCallback(){

                public void visitItem(TreeItem item) {
                    AbstractTree.this.removeItem(item);
                }
            });
            item.setChildren(null);
            this.dirtyItems.add(item);
        }
    }

    private final boolean isNodeVisible(TreeNode node) {
        while (node.getParent() != null) {
            if (!this.isNodeExpanded(node.getParent())) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    private final TreeItem newTreeItem(TreeNode node, int level) {
        return new TreeItem("" + this.idCounter++, node, level);
    }

    private final TreeItem newTreeItem(TreeNode node, int level, String id) {
        return new TreeItem(id, node, level);
    }

    private final Iterator nodeChildren(TreeNode node) {
        return AbstractTree.toIterator(node.children());
    }

    private final void rebuildDirty() {
        Iterator i = this.dirtyItems.iterator();
        while (i.hasNext()) {
            TreeItem item = (TreeItem)((Object)i.next());
            if (item.getChildren() != null) continue;
            this.buildItemChildren(item);
        }
    }

    private void removeItem(TreeItem item) {
        this.dirtyItems.remove((Object)item);
        if (this.dirtyItemsCreateDOM.contains((Object)item)) {
            this.dirtyItemsCreateDOM.remove((Object)item);
        } else {
            this.deleteIds.append(this.getShortItemId(item));
            this.deleteIds.append(",");
        }
        item.remove();
    }

    private final void updated() {
        this.dirtyAll = false;
        this.dirtyItems.clear();
        this.dirtyItemsCreateDOM.clear();
        this.deleteIds.clear();
    }

    private final void visitItemAndChildren(TreeItem item, IItemCallback callback) {
        callback.visitItem(item);
        this.visitItemChildren(item, callback);
    }

    private final void visitItemChildren(TreeItem item, IItemCallback callback) {
        if (item.getChildren() != null) {
            Iterator i = item.getChildren().iterator();
            while (i.hasNext()) {
                TreeItem child = (TreeItem)((Object)i.next());
                this.visitItemAndChildren(child, callback);
            }
        }
    }

    public Component getNodeComponent(TreeNode node) {
        return (Component)this.nodeToItemMap.get(node);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TreeItemContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public TreeItemContainer(String id) {
            super(id);
        }

        public void remove(Component component) {
            if (component instanceof TreeItem) {
                AbstractTree.this.nodeToItemMap.remove(((TreeItem)component).getModelObject());
            }
            super.remove(component);
        }

        protected void onRender(MarkupStream markupStream) {
            int markupStart = markupStream.getCurrentIndex();
            final class Rendered {
                boolean rendered;
                private final /* synthetic */ TreeItemContainer this$1;

                Rendered(TreeItemContainer this$1) {
                    this.this$1 = this$1;
                    this.rendered = false;
                }
            }
            Rendered rendered = new Rendered(this);
            if (AbstractTree.this.rootItem != null) {
                IItemCallback callback = new IItemCallback(this, markupStream, markupStart, rendered){
                    private final /* synthetic */ MarkupStream val$markupStream;
                    private final /* synthetic */ int val$markupStart;
                    private final /* synthetic */ Rendered val$rendered;
                    private final /* synthetic */ TreeItemContainer this$1;
                    {
                        this.this$1 = this$1;
                        this.val$markupStream = val$markupStream;
                        this.val$markupStart = val$markupStart;
                        this.val$rendered = val$rendered;
                    }

                    public void visitItem(TreeItem item) {
                        this.val$markupStream.setCurrentIndex(this.val$markupStart);
                        item.render(this.val$markupStream);
                        this.val$rendered.rendered = true;
                    }
                };
                AbstractTree.this.visitItemAndChildren(AbstractTree.this.rootItem, callback);
            }
            if (!rendered.rendered) {
                markupStream.skipComponent();
            }
        }
    }

    private final class TreeItem
    extends WebMarkupContainer {
        private static final int FLAG_RENDER_CHILDREN = 524288;
        private static final long serialVersionUID = 1L;
        private List children = null;
        private int level;

        public TreeItem(String id, TreeNode node, int level) {
            super(id, (IModel)new Model((Serializable)((Object)node)));
            AbstractTree.this.nodeToItemMap.put(node, this);
            this.level = level;
            this.setOutputMarkupId(true);
            if (level != -1) {
                AbstractTree.this.populateTreeItem(this, level);
            }
        }

        public List getChildren() {
            return this.children;
        }

        public int getLevel() {
            return this.level;
        }

        public String getMarkupId() {
            return AbstractTree.this.getMarkupId() + "_" + this.getId();
        }

        public TreeItem getParentItem() {
            return (TreeItem)((Object)AbstractTree.this.nodeToItemMap.get(((TreeNode)this.getModelObject()).getParent()));
        }

        public void setChildren(List children) {
            this.children = children;
        }

        protected final boolean isRenderChildren() {
            return this.getFlag(524288);
        }

        protected void onRender(MarkupStream markupStream) {
            if (this == AbstractTree.this.rootItem && AbstractTree.this.isRootLess()) {
                this.getResponse().write((CharSequence)("<div style=\"display:none\" id=\"" + this.getMarkupId() + "\"></div>"));
                markupStream.skipComponent();
            } else {
                int index = markupStream.getCurrentIndex();
                super.onRender(markupStream);
                if (this.isRenderChildren()) {
                    AbstractTree.this.visitItemChildren(this, new IItemCallback(this, markupStream, index){
                        private final /* synthetic */ MarkupStream val$markupStream;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ TreeItem this$1;
                        {
                            this.this$1 = this$1;
                            this.val$markupStream = val$markupStream;
                            this.val$index = val$index;
                        }

                        public void visitItem(TreeItem item) {
                            this.val$markupStream.setCurrentIndex(this.val$index);
                            item.onRender(this.val$markupStream);
                        }
                    });
                    this.setRenderChildren(false);
                }
            }
        }

        protected final void setRenderChildren(boolean value) {
            this.setFlag(524288, value);
        }

        protected void onDetach() {
            super.onDetach();
            Object object = this.getModelObject();
            if (object instanceof IDetachable) {
                ((IDetachable)object).detach();
            }
        }
    }

    private static interface IItemCallback {
        public void visitItem(TreeItem var1);
    }
}

