/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tree;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import wicket.Component;
import wicket.MarkupContainer;
import wicket.behavior.AbstractBehavior;
import wicket.behavior.IBehavior;
import wicket.extensions.markup.html.tree.DefaultAbstractTree;
import wicket.markup.ComponentTag;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.basic.Label;
import wicket.model.AbstractReadOnlyModel;
import wicket.model.IModel;

public class Tree
extends DefaultAbstractTree {
    private static final long serialVersionUID = 1L;

    public Tree(String id) {
        super(id);
    }

    public Tree(String id, IModel model) {
        super(id, model);
    }

    public Tree(String id, TreeModel model) {
        super(id, model);
    }

    protected void populateTreeItem(WebMarkupContainer item, int level) {
        final TreeNode node = (TreeNode)item.getModelObject();
        item.add(this.newIndentation((MarkupContainer)item, "indent", (TreeNode)item.getModelObject(), level));
        item.add(this.newJunctionLink((MarkupContainer)item, "link", "image", node));
        MarkupContainer nodeLink = this.newNodeLink((MarkupContainer)item, "nodeLink", node);
        item.add((Component)nodeLink);
        nodeLink.add(this.newNodeIcon(nodeLink, "icon", node));
        nodeLink.add((Component)new Label("label", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject(Component c) {
                return Tree.this.renderNode(node);
            }
        }));
        item.add((IBehavior)new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                if (Tree.this.getTreeState().isNodeSelected(node)) {
                    tag.put("class", (CharSequence)"row-selected");
                } else {
                    tag.put("class", (CharSequence)"row");
                }
            }
        });
    }

    protected String renderNode(TreeNode node) {
        return node.toString();
    }
}

