/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tree.table;

import javax.swing.tree.TreeNode;
import wicket.Component;
import wicket.MarkupContainer;
import wicket.Response;
import wicket.extensions.markup.html.tree.table.AbstractColumn;
import wicket.extensions.markup.html.tree.table.ColumnLocation;
import wicket.extensions.markup.html.tree.table.IRenderable;
import wicket.util.string.Strings;

public abstract class AbstractRenderableColumn
extends AbstractColumn {
    private boolean contentAsTooltip = false;
    private boolean escapeContent = true;

    public AbstractRenderableColumn(ColumnLocation location, String header) {
        super(location, header);
    }

    public abstract String getNodeValue(TreeNode var1);

    public boolean isContentAsTooltip() {
        return this.contentAsTooltip;
    }

    public boolean isEscapeContent() {
        return this.escapeContent;
    }

    public Component newCell(MarkupContainer parent, String id, TreeNode node, int level) {
        return null;
    }

    public IRenderable newCell(TreeNode node, int level) {
        return new IRenderable(){
            private static final long serialVersionUID = 1L;

            public void render(TreeNode node, Response response) {
                String content = AbstractRenderableColumn.this.getNodeValue(node);
                if (AbstractRenderableColumn.this.isEscapeContent()) {
                    content = ((Object)Strings.escapeMarkup((String)content)).toString();
                }
                response.write((CharSequence)"<span");
                if (AbstractRenderableColumn.this.isContentAsTooltip()) {
                    response.write((CharSequence)(" title=\"" + content + "\""));
                }
                response.write((CharSequence)">");
                response.write((CharSequence)content);
                response.write((CharSequence)"</span>");
            }
        };
    }

    public void setContentAsTooltip(boolean contentAsTooltip) {
        this.contentAsTooltip = contentAsTooltip;
    }

    public void setEscapeContent(boolean escapeContent) {
        this.escapeContent = escapeContent;
    }
}

