/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tree.table;

import java.io.Serializable;
import wicket.util.lang.EnumeratedType;

public class ColumnLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Alignment alignment;
    private int size;
    private Unit unit;

    public ColumnLocation(Alignment alignment, int size, Unit unit) {
        this.alignment = alignment;
        this.size = size;
        this.unit = unit;
        if (alignment == Alignment.MIDDLE && unit != Unit.PROPORTIONAL) {
            throw new IllegalArgumentException("For alignment MIDDLE the specified unit must be PROPORTIONAL.");
        }
        if (alignment != Alignment.MIDDLE && unit == Unit.PROPORTIONAL) {
            throw new IllegalArgumentException("Unit PROPORTIONAL can be specified only for columns with alignment MIDDLE.");
        }
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public int getSize() {
        return this.size;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public static final class Unit
    extends EnumeratedType {
        public static Unit EM = new Unit("EM");
        public static Unit PERCENT = new Unit("PERCENT");
        public static Unit PROPORTIONAL = new Unit("PROPORTIONAL");
        public static Unit PX = new Unit("PX");
        private static final long serialVersionUID = 1L;

        public Unit(String name) {
            super(name);
        }
    }

    public static final class Alignment
    extends EnumeratedType {
        public static final Alignment LEFT = new Alignment("LEFT");
        public static final Alignment MIDDLE = new Alignment("MIDDLE");
        public static final Alignment RIGHT = new Alignment("RIGHT");
        private static final long serialVersionUID = 1L;

        public Alignment(String name) {
            super(name);
        }
    }
}

