/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tree.table;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeNode;
import wicket.Component;
import wicket.RequestCycle;
import wicket.Response;
import wicket.extensions.markup.html.tree.table.ColumnLocation;
import wicket.extensions.markup.html.tree.table.IColumn;
import wicket.extensions.markup.html.tree.table.IRenderable;
import wicket.markup.MarkupStream;
import wicket.markup.html.WebMarkupContainer;
import wicket.response.NullResponse;

final class MiddleColumnsView
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final List columns = new ArrayList();
    private final List components = new ArrayList();
    private TreeNode node;
    private final List renderables = new ArrayList();

    public MiddleColumnsView(String id, TreeNode node) {
        super(id);
        this.node = node;
    }

    public void addColumn(IColumn column, Component component, IRenderable renderable) {
        if (column.isVisible()) {
            this.columns.add(column);
            this.components.add(component);
            this.renderables.add(renderable);
        }
    }

    protected double[] computeColumnWidths() {
        int i;
        double[] result = new double[this.columns.size()];
        Arrays.fill(result, 0.0);
        double sum = 0.0;
        double whole = 99.8;
        Iterator i2 = this.columns.iterator();
        while (i2.hasNext()) {
            IColumn column = (IColumn)i2.next();
            if (column.getLocation().getUnit() != ColumnLocation.Unit.PROPORTIONAL) {
                throw new IllegalStateException("Middle columns must have PROPORTIONAL unit set.");
            }
            sum += (double)column.getLocation().getSize();
        }
        int index = 0;
        int spanColumn = 0;
        int spanLeft = 0;
        Iterator i3 = this.columns.iterator();
        while (i3.hasNext()) {
            IColumn column = (IColumn)i3.next();
            int ix = index;
            if (spanLeft > 0) {
                ix = spanColumn;
                --spanLeft;
            }
            int n = ix;
            result[n] = result[n] + (double)Math.round((double)column.getLocation().getSize() / sum * whole);
            if (spanLeft == 0 && column.getSpan(this.node) > 1) {
                int maxSpan = this.columns.size() - this.columns.indexOf(column);
                int span = column.getSpan(this.node) - 1;
                spanColumn = index;
                spanLeft = span < maxSpan ? span : maxSpan;
            }
            ++index;
        }
        double together = 0.0;
        for (i = 0; i < result.length; ++i) {
            together += result[i];
        }
        if (together > 99.8) {
            for (i = result.length - 1; i >= 0; --i) {
                if (result[i] == 0.0) continue;
                int n = i;
                result[n] = result[n] - (together - 99.8);
                break;
            }
        }
        return result;
    }

    protected void onRender(MarkupStream markupStream) {
        int markupStart = markupStream.getCurrentIndex();
        Response response = RequestCycle.get().getResponse();
        double[] widths = this.computeColumnWidths();
        boolean rendered = false;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(0);
        nf.setMaximumFractionDigits(2);
        for (int i = 0; i < this.columns.size(); ++i) {
            Component component = (Component)this.components.get(i);
            IRenderable renderable = (IRenderable)this.renderables.get(i);
            IColumn column = (IColumn)this.columns.get(i);
            response.write((CharSequence)("<span class=\"b_\" style=\"width:" + nf.format(widths[i]) + "%\">"));
            response.write((CharSequence)"<span class=\"c_\">");
            if (component != null) {
                markupStream.setCurrentIndex(markupStart);
                component.render(markupStream);
                rendered = true;
            } else if (renderable != null) {
                renderable.render(this.node, response);
            } else {
                throw new IllegalStateException("Either renderable or cell component must be created for this noode");
            }
            response.write((CharSequence)"</span></span>\n");
            int span = column.getSpan(this.node);
            if (span <= 1) continue;
            for (int j = 1; j < span && i < this.components.size(); ++j) {
                if (this.components.get(++i) == null) continue;
                Response old = RequestCycle.get().setResponse((Response)NullResponse.getInstance());
                markupStream.setCurrentIndex(markupStart);
                ((Component)this.components.get(i)).render(markupStream);
                RequestCycle.get().setResponse(old);
                rendered = true;
            }
        }
        if (!rendered) {
            markupStream.skipComponent();
        }
    }
}

