/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.tree.table;

import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import wicket.Component;
import wicket.MarkupContainer;
import wicket.behavior.AbstractBehavior;
import wicket.behavior.IBehavior;
import wicket.extensions.markup.html.tree.DefaultAbstractTree;
import wicket.extensions.markup.html.tree.table.AbstractTreeColumn;
import wicket.extensions.markup.html.tree.table.ColumnLocation;
import wicket.extensions.markup.html.tree.table.IColumn;
import wicket.extensions.markup.html.tree.table.IRenderable;
import wicket.extensions.markup.html.tree.table.MiddleColumnsView;
import wicket.extensions.markup.html.tree.table.SideColumnsView;
import wicket.markup.ComponentTag;
import wicket.markup.html.PackageResourceReference;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.basic.Label;
import wicket.markup.html.panel.Fragment;
import wicket.model.AbstractReadOnlyModel;
import wicket.model.IModel;

public class TreeTable
extends DefaultAbstractTree {
    private static final PackageResourceReference CSS = new PackageResourceReference(class$wicket$extensions$markup$html$tree$DefaultAbstractTree == null ? (class$wicket$extensions$markup$html$tree$DefaultAbstractTree = TreeTable.class$("wicket.extensions.markup.html.tree.DefaultAbstractTree")) : class$wicket$extensions$markup$html$tree$DefaultAbstractTree, "res/tree-table.css");
    private static final long serialVersionUID = 1L;
    private IColumn[] columns;
    static /* synthetic */ Class class$wicket$extensions$markup$html$tree$DefaultAbstractTree;

    public static Component newTreeCell(MarkupContainer parent, String id, TreeNode node, int level, IRenderNodeCallback callback, TreeTable table) {
        return table.newTreePanel(parent, id, node, level, callback);
    }

    public TreeTable(String id, IColumn[] columns) {
        super(id);
        this.init(columns);
    }

    public TreeTable(String id, IModel model, IColumn[] columns) {
        super(id, model);
        this.init(columns);
    }

    public TreeTable(String id, TreeModel model, IColumn[] columns) {
        super(id, model);
        this.init(columns);
    }

    protected void addHeader() {
        SideColumnsView sideColumns = new SideColumnsView("sideColumns", null);
        this.add((Component)sideColumns);
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                Component component = column.newHeader((MarkupContainer)sideColumns, "" + i);
                sideColumns.add(component);
                sideColumns.addColumn(column, component, null);
            }
        }
        MiddleColumnsView middleColumns = new MiddleColumnsView("middleColumns", null);
        this.add((Component)middleColumns);
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.MIDDLE) continue;
                Component component = column.newHeader((MarkupContainer)middleColumns, "" + i);
                middleColumns.add(component);
                middleColumns.addColumn(column, component, null);
            }
        }
    }

    protected PackageResourceReference getCSS() {
        return CSS;
    }

    protected Component newTreePanel(MarkupContainer parent, String id, TreeNode node, int level, IRenderNodeCallback renderNodeCallback) {
        return new TreeFragment(id, node, level, renderNodeCallback);
    }

    protected void onBeforeAttach() {
        if (this.get("sideColumns") == null) {
            if (this.columns != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    IColumn column = this.columns[i];
                    column.setTreeTable(this);
                }
            }
            this.addHeader();
        }
        super.onAttach();
    }

    protected void populateTreeItem(WebMarkupContainer item, int level) {
        final TreeNode node = (TreeNode)item.getModelObject();
        SideColumnsView sideColumns = new SideColumnsView("sideColumns", node);
        item.add((Component)sideColumns);
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                Component component;
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                IRenderable renderable = column.newCell(node, level);
                if (renderable == null) {
                    component = column.newCell((MarkupContainer)sideColumns, "" + i, node, level);
                    sideColumns.add(component);
                } else {
                    component = null;
                }
                sideColumns.addColumn(column, component, renderable);
            }
        }
        MiddleColumnsView middleColumns = new MiddleColumnsView("middleColumns", node);
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                Component component;
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.MIDDLE) continue;
                IRenderable renderable = column.newCell(node, level);
                if (renderable == null) {
                    component = column.newCell((MarkupContainer)middleColumns, "" + i, node, level);
                    middleColumns.add(component);
                } else {
                    component = null;
                }
                middleColumns.addColumn(column, component, renderable);
            }
        }
        item.add((Component)middleColumns);
        item.add((IBehavior)new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                if (TreeTable.this.getTreeState().isNodeSelected(node)) {
                    tag.put("class", (CharSequence)"row-selected");
                } else {
                    tag.put("class", (CharSequence)"row");
                }
            }
        });
    }

    private void init(IColumn[] columns) {
        boolean found = false;
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                IColumn column = columns[i];
                if (!(column instanceof AbstractTreeColumn)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalArgumentException("At least one column in TreeTable must be derived from AbstractTreeColumn.");
        }
        this.columns = columns;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TreeFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public TreeFragment(String id, TreeNode node, int level, IRenderNodeCallback renderNodeCallback) {
            super(id, "fragment");
            this.add(TreeTable.this.newIndentation((MarkupContainer)this, "indent", node, level));
            this.add(TreeTable.this.newJunctionLink((MarkupContainer)this, "link", "image", node));
            MarkupContainer nodeLink = TreeTable.this.newNodeLink((MarkupContainer)this, "nodeLink", node);
            this.add((Component)nodeLink);
            nodeLink.add(TreeTable.this.newNodeIcon(nodeLink, "icon", node));
            nodeLink.add((Component)new Label("label", (IModel)new AbstractReadOnlyModel(this, renderNodeCallback, node){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ IRenderNodeCallback val$renderNodeCallback;
                private final /* synthetic */ TreeNode val$node;
                private final /* synthetic */ TreeFragment this$1;
                {
                    this.this$1 = this$1;
                    this.val$renderNodeCallback = val$renderNodeCallback;
                    this.val$node = val$node;
                }

                public Object getObject(Component c) {
                    return this.val$renderNodeCallback.renderNode(this.val$node);
                }
            }));
        }
    }

    public static interface IRenderNodeCallback
    extends Serializable {
        public String renderNode(TreeNode var1);
    }
}

