/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.rating;

import java.io.Serializable;
import wicket.Component;
import wicket.ResourceReference;
import wicket.ajax.AjaxRequestTarget;
import wicket.ajax.markup.html.AjaxFallbackLink;
import wicket.behavior.HeaderContributor;
import wicket.behavior.IBehavior;
import wicket.behavior.SimpleAttributeModifier;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.basic.Label;
import wicket.markup.html.list.Loop;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;
import wicket.model.Model;
import wicket.model.StringResourceModel;

public abstract class RatingPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference STAR0 = new ResourceReference(class$wicket$extensions$rating$RatingPanel == null ? (class$wicket$extensions$rating$RatingPanel = RatingPanel.class$("wicket.extensions.rating.RatingPanel")) : class$wicket$extensions$rating$RatingPanel, "star0.gif");
    public static final ResourceReference STAR1 = new ResourceReference(class$wicket$extensions$rating$RatingPanel == null ? (class$wicket$extensions$rating$RatingPanel = RatingPanel.class$("wicket.extensions.rating.RatingPanel")) : class$wicket$extensions$rating$RatingPanel, "star1.gif");
    private IModel nrOfStars = new Model((Serializable)new Integer(5));
    private IModel nrOfVotes;
    private IModel hasVoted;
    private Component ratingLabel;
    static /* synthetic */ Class class$wicket$extensions$rating$RatingPanel;

    public RatingPanel(String id) {
        this(id, null, 5, true);
    }

    public RatingPanel(String id, IModel rating) {
        this(id, rating, (IModel)new Model((Serializable)new Integer(5)), null, (IModel)new Model((Serializable)Boolean.FALSE), true);
    }

    public RatingPanel(String id, int nrOfStars) {
        this(id, null, 5, true);
    }

    public RatingPanel(String id, IModel rating, int nrOfStars, boolean addDefaultCssStyle) {
        this(id, rating, (IModel)new Model((Serializable)new Integer(nrOfStars)), null, (IModel)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel rating, int nrOfStars, IModel nrOfVotes, boolean addDefaultCssStyle) {
        this(id, rating, (IModel)new Model((Serializable)new Integer(nrOfStars)), nrOfVotes, (IModel)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel rating, IModel nrOfStars, IModel nrOfVotes, IModel hasVoted, boolean addDefaultCssStyle) {
        super(id, rating);
        this.nrOfStars = nrOfStars;
        this.nrOfVotes = nrOfVotes;
        this.hasVoted = hasVoted;
        WebMarkupContainer rater = new WebMarkupContainer("rater");
        rater.add(this.newRatingStarBar("element", nrOfStars));
        this.ratingLabel = this.newRatingLabel("rating", rating, nrOfVotes);
        rater.add(this.ratingLabel);
        rater.setOutputMarkupId(true);
        this.add((Component)rater);
        this.setRenderBodyOnly(true);
        if (addDefaultCssStyle) {
            this.addDefaultCssStyle();
        }
    }

    public final void addDefaultCssStyle() {
        this.add((IBehavior)HeaderContributor.forCss((Class)(class$wicket$extensions$rating$RatingPanel == null ? (class$wicket$extensions$rating$RatingPanel = RatingPanel.class$("wicket.extensions.rating.RatingPanel")) : class$wicket$extensions$rating$RatingPanel), (String)"RatingPanel.css"));
    }

    protected Component newRatingStarBar(String id, IModel nrOfStars) {
        return new RatingStarBar(id, nrOfStars);
    }

    protected Component newRatingLabel(String id, IModel rating, IModel nrOfVotes) {
        StringResourceModel model = null;
        if (nrOfVotes == null) {
            Object[] parameters = new Object[]{rating};
            model = new StringResourceModel("rating.simple", (Component)this, null, parameters);
        } else {
            Object[] parameters = new Object[]{rating, nrOfVotes};
            model = new StringResourceModel("rating.complete", (Component)this, null, parameters);
        }
        return new Label(id, (IModel)model);
    }

    protected String getActiveStarUrl(int iteration) {
        return ((Object)this.getRequestCycle().urlFor(STAR1)).toString();
    }

    protected String getInactiveStarUrl(int iteration) {
        return ((Object)this.getRequestCycle().urlFor(STAR0)).toString();
    }

    public RatingPanel setRatingLabelVisible(boolean visible) {
        this.ratingLabel.setVisible(visible);
        return this;
    }

    protected abstract boolean onIsStarActive(int var1);

    protected abstract void onRated(int var1, AjaxRequestTarget var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class RatingStarBar
    extends Loop {
        private static final long serialVersionUID = 1L;

        private RatingStarBar(String id, IModel model) {
            super(id, model);
        }

        protected void populateItem(Loop.LoopItem item) {
            AjaxFallbackLink link = new AjaxFallbackLink("link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Loop.LoopItem item = (Loop.LoopItem)this.getParent();
                    RatingPanel.this.onRated(item.getIteration() + 1, target);
                    if (target != null) {
                        target.addComponent(RatingPanel.this.get("rater"));
                    }
                }

                public boolean isEnabled() {
                    return (Boolean)RatingPanel.this.hasVoted.getObject((Component)RatingPanel.this) == false;
                }
            };
            int iteration = item.getIteration();
            link.add(new WebMarkupContainer("star").add((IBehavior)new SimpleAttributeModifier("src", (CharSequence)(RatingPanel.this.onIsStarActive(iteration) ? RatingPanel.this.getActiveStarUrl(iteration) : RatingPanel.this.getInactiveStarUrl(iteration)))));
            item.add((Component)link);
        }
    }
}

