/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.util.resource;

import java.util.Map;
import wicket.Component;
import wicket.behavior.StringHeaderContributor;
import wicket.extensions.util.resource.CssTemplate;
import wicket.extensions.util.resource.JavaScriptTemplate;
import wicket.extensions.util.resource.PackagedTextTemplate;
import wicket.extensions.util.resource.TextTemplate;
import wicket.model.AbstractReadOnlyDetachableModel;
import wicket.model.IModel;

public class TextTemplateHeaderContributor
extends StringHeaderContributor {
    private static final long serialVersionUID = 1L;

    public static TextTemplateHeaderContributor forCss(TextTemplate template, IModel variablesModel) {
        return new TextTemplateHeaderContributor(new CssTemplate(template), variablesModel);
    }

    public static TextTemplateHeaderContributor forCss(Class clazz, String fileName, IModel variablesModel) {
        return TextTemplateHeaderContributor.forCss(new PackagedTextTemplate(clazz, fileName), variablesModel);
    }

    public static TextTemplateHeaderContributor forJavaScript(TextTemplate template, IModel variablesModel) {
        return new TextTemplateHeaderContributor(new JavaScriptTemplate(template), variablesModel);
    }

    public static TextTemplateHeaderContributor forJavaScript(Class clazz, String fileName, IModel variablesModel) {
        return TextTemplateHeaderContributor.forJavaScript(new PackagedTextTemplate(clazz, fileName), variablesModel);
    }

    protected TextTemplateHeaderContributor(TextTemplate template, IModel variablesModel) {
        super((IModel)new TemplateModel(template, variablesModel));
    }

    private static final class TemplateModel
    extends AbstractReadOnlyDetachableModel {
        private static final long serialVersionUID = 1L;
        private final TextTemplate template;
        private final IModel variablesModel;

        protected TemplateModel(TextTemplate template, IModel variablesModel) {
            if (template == null) {
                throw new IllegalArgumentException("argument template must be not null");
            }
            this.template = template;
            this.variablesModel = variablesModel;
        }

        public IModel getNestedModel() {
            return null;
        }

        protected void onAttach() {
        }

        protected void onDetach() {
            if (this.variablesModel != null) {
                this.variablesModel.detach();
            }
        }

        protected Object onGetObject(Component component) {
            Map variables;
            if (this.variablesModel != null && (variables = (Map)this.variablesModel.getObject(component)) != null) {
                return this.template.asString(variables);
            }
            return this.template.asString();
        }
    }
}

