/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.wizard;

import java.io.Serializable;
import wicket.Component;
import wicket.extensions.wizard.WizardStep;
import wicket.markup.html.basic.Label;
import wicket.model.IModel;
import wicket.model.Model;

public class StaticContentStep
extends WizardStep {
    private static final long serialVersionUID = 1L;
    private final boolean allowHtml;
    private IModel content;

    public StaticContentStep(boolean allowHtml) {
        this.allowHtml = allowHtml;
        this.add((Component)new Label("content", ""));
    }

    public StaticContentStep(IModel title, IModel summary, IModel content, boolean allowHtml) {
        super(title, summary);
        this.content = content;
        this.allowHtml = allowHtml;
        this.add(new Label("content", content).setEscapeModelStrings(!allowHtml));
    }

    public StaticContentStep(IModel title, IModel summary, String content, boolean allowHtml) {
        this(title, summary, (IModel)new Model((Serializable)((Object)content)), allowHtml);
    }

    public StaticContentStep(String title, String summary, IModel content, boolean allowHtml) {
        this((IModel)new Model((Serializable)((Object)title)), (IModel)new Model((Serializable)((Object)summary)), content, allowHtml);
    }

    public StaticContentStep(String title, String summary, String content, boolean allowHtml) {
        this(title, summary, (IModel)new Model((Serializable)((Object)content)), allowHtml);
    }

    public final boolean getAllowHtml() {
        return this.allowHtml;
    }

    public final String getContent() {
        return this.content != null ? (String)this.content.getObject((Component)this) : null;
    }

    public final IModel getContentModel() {
        return this.content;
    }

    public final void setContentModel(IModel content) {
        this.content = content;
        this.replace(new Label("content", content).setEscapeModelStrings(!this.allowHtml));
    }
}

