/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.wizard;

import java.util.Iterator;
import wicket.Component;
import wicket.MarkupContainer;
import wicket.behavior.HeaderContributor;
import wicket.behavior.IBehavior;
import wicket.extensions.wizard.IWizard;
import wicket.extensions.wizard.IWizardModel;
import wicket.extensions.wizard.IWizardModelListener;
import wicket.extensions.wizard.IWizardStep;
import wicket.extensions.wizard.WizardButtonBar;
import wicket.feedback.ContainerFeedbackMessageFilter;
import wicket.feedback.IFeedbackMessageFilter;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.form.Form;
import wicket.markup.html.panel.FeedbackPanel;
import wicket.markup.html.panel.Panel;

public class Wizard
extends Panel
implements IWizardModelListener,
IWizard {
    public static final String BUTTONS_ID = "buttons";
    public static final String FEEDBACK_ID = "feedback";
    public static final String HEADER_ID = "header";
    public static final String OVERVIEW_ID = "overview";
    public static final String VIEW_ID = "view";
    private static final long serialVersionUID = 1L;
    private IWizardStep activeStep;
    private Form form;
    private IWizardModel wizardModel;
    static /* synthetic */ Class class$wicket$extensions$wizard$Wizard;

    public Wizard(String id) {
        this(id, true);
    }

    public Wizard(String id, boolean addDefaultCssStyle) {
        super(id);
        if (addDefaultCssStyle) {
            this.addDefaultCssStyle();
        }
    }

    public Wizard(String id, IWizardModel wizardModel) {
        this(id, wizardModel, true);
    }

    public Wizard(String id, IWizardModel wizardModel, boolean addDefaultCssStyle) {
        super(id);
        this.init(wizardModel);
        if (addDefaultCssStyle) {
            this.addDefaultCssStyle();
        }
    }

    public final void addDefaultCssStyle() {
        this.add((IBehavior)HeaderContributor.forCss((Class)(class$wicket$extensions$wizard$Wizard == null ? (class$wicket$extensions$wizard$Wizard = Wizard.class$("wicket.extensions.wizard.Wizard")) : class$wicket$extensions$wizard$Wizard), (String)"Wizard.css"));
    }

    public final IWizardStep getActiveStep() {
        return this.getWizardModel().getActiveStep();
    }

    public final Form getForm() {
        return this.form;
    }

    public final IWizardModel getWizardModel() {
        return this.wizardModel;
    }

    public boolean isVersioned() {
        return false;
    }

    public void onActiveStepChanged(IWizardStep newStep) {
        this.activeStep = newStep;
        this.form.replace(this.activeStep.getView(VIEW_ID, (Component)this, this));
        this.form.replace(this.activeStep.getHeader(HEADER_ID, (Component)this, this));
    }

    public void onCancel() {
    }

    public void onFinish() {
    }

    protected void init(IWizardModel wizardModel) {
        if (wizardModel == null) {
            throw new IllegalArgumentException("argument wizardModel must be not null");
        }
        this.wizardModel = wizardModel;
        this.form = new Form("form");
        this.add((Component)this.form);
        this.form.add((Component)new WebMarkupContainer(HEADER_ID));
        this.form.add((Component)this.newFeedbackPanel(FEEDBACK_ID));
        this.form.add((Component)new WebMarkupContainer(VIEW_ID));
        this.form.add(this.newButtonBar(BUTTONS_ID));
        this.form.add(this.newOverviewBar(OVERVIEW_ID));
        wizardModel.addListener(this);
        Iterator iter = wizardModel.stepIterator();
        while (iter.hasNext()) {
            ((IWizardStep)iter.next()).init(wizardModel);
        }
        wizardModel.reset();
    }

    protected Component newButtonBar(String id) {
        return new WizardButtonBar(id, this);
    }

    protected FeedbackPanel newFeedbackPanel(String id) {
        return new FeedbackPanel(id, (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)this));
    }

    protected Component newOverviewBar(String id) {
        return new WebMarkupContainer(id).setVisible(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

