/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.wizard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import wicket.extensions.wizard.IWizardModel;
import wicket.extensions.wizard.IWizardModelListener;
import wicket.extensions.wizard.IWizardStep;
import wicket.util.collections.ArrayListStack;

public class WizardModel
implements IWizardModel {
    public static final ICondition TRUE = new ICondition(){
        private static final long serialVersionUID = 1L;

        public boolean evaluate() {
            return true;
        }
    };
    private static final long serialVersionUID = 1L;
    private IWizardStep activeStep;
    private boolean cancelVisible = true;
    private List conditions = new ArrayList();
    private final ArrayListStack history = new ArrayListStack();
    private boolean lastVisible = false;
    private List steps = new ArrayList();
    private final List wizardModelListeners = new ArrayList(1);

    public void add(IWizardStep step) {
        if (step instanceof ICondition) {
            this.add(step, (ICondition)((Object)step));
        } else {
            this.add(step, TRUE);
        }
    }

    public void add(IWizardStep step, ICondition condition) {
        this.steps.add(step);
        this.conditions.add(condition);
    }

    public final void addListener(IWizardModelListener listener) {
        this.wizardModelListeners.add(listener);
    }

    public void cancel() {
        this.fireWizardCancelled();
    }

    public void finish() {
        this.fireWizardFinished();
    }

    public final IWizardStep getActiveStep() {
        return this.activeStep;
    }

    public boolean isCancelVisible() {
        return this.cancelVisible;
    }

    public final boolean isLastAvailable() {
        return this.allStepsComplete() && !this.isLastStep(this.activeStep);
    }

    public boolean isLastStep(IWizardStep step) {
        return this.findLastStep().equals(step);
    }

    public boolean isLastVisible() {
        return this.lastVisible;
    }

    public final boolean isNextAvailable() {
        return this.activeStep.isComplete() && !this.isLastStep(this.activeStep);
    }

    public final boolean isPreviousAvailable() {
        return !this.history.isEmpty();
    }

    public void lastStep() {
        this.history.push((Object)this.getActiveStep());
        IWizardStep lastStep = this.findLastStep();
        this.setActiveStep(lastStep);
    }

    public void next() {
        this.history.push((Object)this.getActiveStep());
        IWizardStep step = this.findNextVisibleStep();
        this.setActiveStep(step);
    }

    public void previous() {
        IWizardStep step = (IWizardStep)this.history.pop();
        this.setActiveStep(step);
    }

    public final void removeListener(IWizardModelListener listener) {
        this.wizardModelListeners.remove(listener);
    }

    public void reset() {
        this.history.clear();
        this.activeStep = null;
        this.setActiveStep(this.findNextVisibleStep());
    }

    public void setActiveStep(IWizardStep step) {
        if (this.activeStep != null && step != null && this.activeStep.equals(step)) {
            return;
        }
        IWizardStep old = this.activeStep;
        this.activeStep = step;
        this.fireActiveStepChanged(step);
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.cancelVisible = cancelVisible;
    }

    public void setLastVisible(boolean lastVisible) {
        this.lastVisible = lastVisible;
    }

    public final Iterator stepIterator() {
        return this.steps.iterator();
    }

    protected final boolean allStepsComplete() {
        Iterator iterator = this.stepIterator();
        while (iterator.hasNext()) {
            if (((IWizardStep)iterator.next()).isComplete()) continue;
            return false;
        }
        return true;
    }

    protected final IWizardStep findLastStep() {
        for (int i = this.conditions.size() - 1; i >= 0; --i) {
            ICondition condition = (ICondition)this.conditions.get(i);
            if (!condition.evaluate()) continue;
            return (IWizardStep)this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no visible steps");
    }

    protected final IWizardStep findNextVisibleStep() {
        int startIndex;
        for (int i = startIndex = this.activeStep == null ? 0 : this.steps.indexOf(this.activeStep) + 1; i < this.conditions.size(); ++i) {
            ICondition condition = (ICondition)this.conditions.get(i);
            if (!condition.evaluate()) continue;
            return (IWizardStep)this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no more visible steps");
    }

    protected final void fireActiveStepChanged(IWizardStep step) {
        Iterator i = this.wizardModelListeners.iterator();
        while (i.hasNext()) {
            IWizardModelListener listener = (IWizardModelListener)i.next();
            listener.onActiveStepChanged(step);
        }
    }

    protected final void fireWizardCancelled() {
        Iterator i = this.wizardModelListeners.iterator();
        while (i.hasNext()) {
            IWizardModelListener listener = (IWizardModelListener)i.next();
            listener.onCancel();
        }
    }

    protected final void fireWizardFinished() {
        Iterator i = this.wizardModelListeners.iterator();
        while (i.hasNext()) {
            IWizardModelListener listener = (IWizardModelListener)i.next();
            listener.onFinish();
        }
    }

    public static interface ICondition
    extends Serializable {
        public boolean evaluate();
    }
}

