/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.wizard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import wicket.Component;
import wicket.extensions.wizard.IWizard;
import wicket.extensions.wizard.IWizardModel;
import wicket.extensions.wizard.IWizardStep;
import wicket.markup.html.basic.Label;
import wicket.markup.html.form.Form;
import wicket.markup.html.form.FormComponent;
import wicket.markup.html.form.validation.IFormValidator;
import wicket.markup.html.panel.Panel;
import wicket.model.AbstractReadOnlyModel;
import wicket.model.CompoundPropertyModel;
import wicket.model.IModel;
import wicket.model.Model;

public class WizardStep
extends Panel
implements IWizardStep {
    private static final long serialVersionUID = 1L;
    private boolean complete;
    private transient AddFormValidatorAction onAttachAction;
    private IModel summary;
    private IModel title;
    private IWizardModel wizardModel;
    static /* synthetic */ Class class$wicket$markup$html$form$Form;

    protected void detachModel() {
        super.detachModel();
        if (this.title != null) {
            this.title.detach();
        }
        if (this.summary != null) {
            this.summary.detach();
        }
    }

    public WizardStep() {
        super("view");
    }

    public WizardStep(IModel title, IModel summary) {
        this(title, summary, null);
    }

    public WizardStep(IModel title, IModel summary, IModel model) {
        super("view", model);
        this.title = title;
        this.summary = summary;
    }

    public WizardStep(String title, String summary) {
        this(title, summary, null);
    }

    public WizardStep(String title, String summary, IModel model) {
        this((IModel)new Model((Serializable)((Object)title)), (IModel)new Model((Serializable)((Object)summary)), model);
    }

    public final void add(IFormValidator validator) {
        if (this.onAttachAction == null) {
            this.onAttachAction = new AddFormValidatorAction();
        }
        this.onAttachAction.formValidatorWrapper.add(validator);
    }

    public void applyState() {
        this.complete = true;
    }

    public Component getHeader(String id, Component parent, IWizard wizard) {
        return new Header(id, wizard);
    }

    public String getSummary() {
        return this.summary != null ? (String)this.summary.getObject((Component)this) : (String)null;
    }

    public String getTitle() {
        return this.title != null ? (String)this.title.getObject((Component)this) : (String)null;
    }

    public Component getView(String id, Component parent, IWizard wizard) {
        return this;
    }

    public final void init(IWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.onInit(wizardModel);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setSummaryModel(IModel summary) {
        this.summary = summary;
    }

    public void setTitleModel(IModel title) {
        this.title = title;
    }

    protected void onAttach() {
        if (this.onAttachAction != null) {
            this.onAttachAction.execute();
            this.onAttachAction = null;
        }
    }

    protected void onInit(IWizardModel wizardModel) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class Header
    extends Panel {
        private static final long serialVersionUID = 1L;

        public Header(String id, IWizard wizard) {
            super(id);
            this.setModel((IModel)new CompoundPropertyModel((Object)wizard));
            this.add(new Label("title", (IModel)new AbstractReadOnlyModel(){
                private static final long serialVersionUID = 1L;

                public Object getObject(Component component) {
                    return WizardStep.this.getTitle();
                }
            }).setEscapeModelStrings(false));
            this.add(new Label("summary", (IModel)new AbstractReadOnlyModel(this){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ Header this$1;
                {
                    this.this$1 = this$1;
                }

                public Object getObject(Component component) {
                    return Header.access$200(this.this$1).getSummary();
                }
            }).setEscapeModelStrings(false));
        }
    }

    private final class FormValidatorWrapper
    implements IFormValidator {
        private static final long serialVersionUID = 1L;
        private final List validators = new ArrayList();

        private FormValidatorWrapper() {
        }

        public final void add(IFormValidator validator) {
            this.validators.add(validator);
        }

        public FormComponent[] getDependentFormComponents() {
            if (this.isActiveStep()) {
                HashSet<FormComponent> components = new HashSet<FormComponent>();
                Iterator i = this.validators.iterator();
                while (i.hasNext()) {
                    IFormValidator v = (IFormValidator)i.next();
                    FormComponent[] dependentComponents = v.getDependentFormComponents();
                    if (dependentComponents == null) continue;
                    int len = dependentComponents.length;
                    for (int j = 0; j < len; ++j) {
                        components.add(dependentComponents[j]);
                    }
                }
                return components.toArray(new FormComponent[components.size()]);
            }
            return null;
        }

        public void validate(Form form) {
            if (this.isActiveStep()) {
                Iterator i = this.validators.iterator();
                while (i.hasNext()) {
                    IFormValidator v = (IFormValidator)i.next();
                    v.validate(form);
                }
            }
        }

        private final boolean isActiveStep() {
            return WizardStep.this.wizardModel.getActiveStep().equals(WizardStep.this);
        }
    }

    private final class AddFormValidatorAction {
        final FormValidatorWrapper formValidatorWrapper;

        private AddFormValidatorAction() {
            this.formValidatorWrapper = new FormValidatorWrapper();
        }

        void execute() {
            Form form = (Form)WizardStep.this.findParent(class$wicket$markup$html$form$Form == null ? (class$wicket$markup$html$form$Form = WizardStep.class$("wicket.markup.html.form.Form")) : class$wicket$markup$html$form$Form);
            form.add((IFormValidator)this.formValidatorWrapper);
        }
    }
}

