/*
 * Decompiled with CFR 0.152.
 */
package wicket.jmx;

import java.io.IOException;
import wicket.jmx.ApplicationMBean;
import wicket.protocol.http.WebApplication;
import wicket.request.IRequestCodingStrategy;
import wicket.request.IRequestTargetMountsInfo;
import wicket.request.target.coding.IMountableRequestTargetUrlCodingStrategy;
import wicket.request.target.coding.IRequestTargetUrlCodingStrategy;

public class Application
implements ApplicationMBean {
    private final wicket.Application application;
    private final WebApplication webApplication;

    public Application(wicket.Application application) {
        this.application = application;
        this.webApplication = application instanceof WebApplication ? (WebApplication)application : null;
    }

    public void clearMarkupCache() throws IOException {
        this.application.getMarkupCache().clear();
    }

    public String getApplicationClass() throws IOException {
        return this.application.getClass().getName();
    }

    public String getConfigurationType() {
        return this.application.getConfigurationType();
    }

    public String getHomePageClass() throws IOException {
        return this.application.getClass().getName();
    }

    public int getMarkupCacheSize() throws IOException {
        return this.application.getMarkupCache().size();
    }

    public String[] getMounts() throws IOException {
        IRequestCodingStrategy mounter;
        if (this.webApplication != null && (mounter = this.webApplication.getRequestCycleProcessor().getRequestCodingStrategy()) instanceof IRequestTargetMountsInfo) {
            IRequestTargetMountsInfo mountsInfo = (IRequestTargetMountsInfo)mounter;
            IRequestTargetUrlCodingStrategy[] targets = mountsInfo.listMounts();
            String[] results = new String[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                results[i] = targets[i] instanceof IMountableRequestTargetUrlCodingStrategy ? ((IMountableRequestTargetUrlCodingStrategy)targets[i]).getMountPath() + " - " + targets[i].toString() : "/? - " + targets[i].toString();
            }
            return results;
        }
        return null;
    }

    public String getWicketVersion() throws IOException {
        return this.application.getFrameworkSettings().getVersion();
    }
}

