/*
 * Decompiled with CFR 0.152.
 */
package wicket.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wicket.IDestroyer;
import wicket.IInitializer;
import wicket.WicketRuntimeException;
import wicket.jmx.Application;
import wicket.jmx.ApplicationSettings;
import wicket.jmx.CookieValuePersisterSettings;
import wicket.jmx.DebugSettings;
import wicket.jmx.MarkupSettings;
import wicket.jmx.PageSettings;
import wicket.jmx.RequestCycleSettings;
import wicket.jmx.RequestLogger;
import wicket.jmx.ResourceSettings;
import wicket.jmx.SecuritySettings;
import wicket.jmx.SessionSettings;

public class Initializer
implements IInitializer,
IDestroyer {
    private static Log log = LogFactory.getLog(Initializer.class);
    private List<ObjectName> registered = new ArrayList<ObjectName>();

    public void destroy(wicket.Application application) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName objectName : this.registered) {
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void init(wicket.Application application) {
        try {
            String name = application.getName();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            String domain = "wicket.app." + name;
            ObjectName appBeanName = new ObjectName(domain + ":type=Application");
            String tempDomain = domain;
            int i = 0;
            while (mbs.isRegistered(appBeanName)) {
                tempDomain = name + "-" + i++;
                appBeanName = new ObjectName(tempDomain + ":type=Application");
            }
            domain = tempDomain;
            Application appBean = new Application(application);
            this.register(mbs, appBean, appBeanName);
            this.register(mbs, new ApplicationSettings(application), new ObjectName(domain + ":type=Application,name=ApplicationSettings"));
            this.register(mbs, new DebugSettings(application), new ObjectName(domain + ":type=Application,name=DebugSettings"));
            this.register(mbs, new MarkupSettings(application), new ObjectName(domain + ":type=Application,name=MarkupSettings"));
            this.register(mbs, new ResourceSettings(application), new ObjectName(domain + ":type=Application,name=ResourceSettings"));
            this.register(mbs, new PageSettings(application), new ObjectName(domain + ":type=Application,name=PageSettings"));
            this.register(mbs, new RequestCycleSettings(application), new ObjectName(domain + ":type=Application,name=RequestCycleSettings"));
            this.register(mbs, new SecuritySettings(application), new ObjectName(domain + ":type=Application,name=SecuritySettings"));
            this.register(mbs, new SessionSettings(application), new ObjectName(domain + ":type=Application,name=SessionSettings"));
            this.register(mbs, new CookieValuePersisterSettings(application), new ObjectName(domain + ":type=Application,name=CookieValuePersisterSettings"));
            RequestLogger sessionsBean = new RequestLogger(application);
            ObjectName sessionsBeanName = new ObjectName(domain + ":type=RequestLogger");
            this.register(mbs, sessionsBean, sessionsBeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return "Wicket JMX initializer";
    }

    private void register(MBeanServer mbs, Object o, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        mbs.registerMBean(o, objectName);
        this.registered.add(objectName);
    }
}

