/*
 * Decompiled with CFR 0.152.
 */
package wicket.jmx;

import java.io.IOException;
import wicket.Application;
import wicket.jmx.RequestLoggerMBean;
import wicket.protocol.http.WebApplication;

public class RequestLogger
implements RequestLoggerMBean {
    private final Application application;
    private final WebApplication webApplication;

    public RequestLogger(Application application) {
        this.application = application;
        this.webApplication = application instanceof WebApplication ? (WebApplication)application : null;
    }

    public Integer getNumberOfCreatedSessions() throws IOException {
        wicket.protocol.http.RequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getTotalCreatedSessions();
        }
        return null;
    }

    public Integer getNumberOfLiveSessions() throws IOException {
        wicket.protocol.http.RequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getLiveSessions().size();
        }
        return null;
    }

    public Integer getPeakNumberOfSessions() throws IOException {
        wicket.protocol.http.RequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            return logger.getPeakSessions();
        }
        return null;
    }

    public void restart() throws IOException {
        if (this.webApplication != null) {
            this.webApplication.setRequestLogger(new wicket.protocol.http.RequestLogger());
        }
    }

    public void stop() throws IOException {
        if (this.webApplication != null) {
            this.webApplication.setRequestLogger(null);
        }
    }

    protected wicket.protocol.http.RequestLogger getRequestLogger() {
        if (this.application instanceof WebApplication) {
            return ((WebApplication)this.application).getRequestLogger();
        }
        return null;
    }
}

