/*
 * Decompiled with CFR 0.152.
 */
package wiki.capsule.flow.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiki.capsule.flow.entity.FlowBasic;
import wiki.capsule.flow.entity.FlowLog;
import wiki.capsule.flow.entity.FlowRound;
import wiki.capsule.flow.enums.TodoEnum;
import wiki.capsule.flow.exception.FlowException;
import wiki.capsule.flow.service.FlowBasicService;
import wiki.capsule.flow.service.FlowLogService;
import wiki.capsule.flow.service.FlowRoundService;
import wiki.capsule.flow.utils.ClassUtils;
import wiki.capsule.flow.utils.RuleUtils;
import wiki.capsule.flow.vo.FlowMetaVo;
import wiki.capsule.flow.vo.FlowRootVo;
import wiki.capsule.flow.vo.FlowTraceVo;

public abstract class AbstractFlowHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractFlowHandler.class);
    @Resource
    private FlowBasicService flowBasicService;
    @Resource
    private FlowLogService flowLogService;
    @Resource
    private FlowRoundService flowRoundService;
    private static final String EX_AND = "&&";
    private static final String EX_OR = "||";
    private static final String EX_OR_ESCAPE = "\\|\\|";

    public List<FlowBasic> process(T bizEntity, String action, String comment, String user, boolean isSubmit, boolean isRestart) {
        this.verifyParam(bizEntity, action, comment, user);
        Long flowRoundId = this.setFlowRoundId(bizEntity, user, isRestart);
        String approvalStatus = ClassUtils.getStringValue(bizEntity, this.getApprovalStatusField());
        if (StringUtils.isBlank((CharSequence)approvalStatus)) {
            throw new FlowException(10016, "You have not initial approvalStatus field.");
        }
        List<FlowBasic> currentFlows = this.findCurrentFlows(approvalStatus, action, flowRoundId);
        if (CollectionUtils.isEmpty(currentFlows)) {
            throw new FlowException(10017, "Next flow not found before " + approvalStatus + " with action " + action + ".");
        }
        List<FlowBasic> canHandleFlows = this.authPermission(currentFlows, user);
        if (CollectionUtils.isEmpty(canHandleFlows)) {
            throw new FlowException(10009, "Current user does not have permission to handle this flow.");
        }
        String nextStatus = this.startProcess(currentFlows, canHandleFlows, bizEntity);
        if (isSubmit) {
            this.setSubmitField(bizEntity, comment, user);
        } else {
            this.setAuditField(bizEntity, comment, user);
        }
        this.saveFlowLogs(canHandleFlows, nextStatus, comment, user, ClassUtils.getLongValue(bizEntity, this.getIdFiled()), flowRoundId);
        this.afterProcess(bizEntity);
        return canHandleFlows;
    }

    protected void afterProcess(T bizEntity) {
    }

    protected void saveFlowLogs(List<FlowBasic> canHandleFlows, String nextStatus, String comment, String user, Long orderId, Long flowRoundId) {
        ArrayList<FlowLog> logs = new ArrayList<FlowLog>();
        for (FlowBasic flowBasic : canHandleFlows) {
            logs.add(new FlowLog().setEntityName(this.getEntityName()).setFlowName(this.getFlowName()).setNextStatus(nextStatus).setComments(comment).setRoundId(flowRoundId).setPrevStatus(flowBasic.getPrevStatus()).setCreatedBy(user).setOrderId(orderId).setAction(flowBasic.getAction()));
        }
        this.flowLogService.saveBatch(logs);
    }

    protected void setAuditField(T bizEntity, String comment, String user) {
        ClassUtils.setFieldValue(bizEntity, this.getLastAuditByField(), user);
        ClassUtils.setFieldValue(bizEntity, this.getLastAuditDateFiled(), LocalDateTime.now());
        ClassUtils.setFieldValue(bizEntity, this.getLastAuditMessageFiled(), comment);
    }

    protected void setSubmitField(T bizEntity, String comment, String user) {
        ClassUtils.setFieldValue(bizEntity, this.getLastSubmitByField(), user);
        ClassUtils.setFieldValue(bizEntity, this.getLastSubmitDateFiled(), LocalDateTime.now());
        ClassUtils.setFieldValue(bizEntity, this.getLastSubmitMessageFiled(), comment);
    }

    protected String startProcess(List<FlowBasic> currentFlows, List<FlowBasic> canHandleFlows, T bizEntity) {
        String approvalStatus = ClassUtils.getStringValue(bizEntity, this.getApprovalStatusField());
        String approvalStatusJson = ClassUtils.getStringValue(bizEntity, this.getApprovalStatusJsonField());
        if (StringUtils.isBlank((CharSequence)approvalStatus) || StringUtils.isBlank((CharSequence)approvalStatusJson)) {
            throw new FlowException(10016, "You have not initial approvalStatus or approvalStatusJson field.");
        }
        JSONObject json = JSONObject.parseObject((String)approvalStatusJson);
        if (approvalStatus.contains(EX_AND) && currentFlows.size() > canHandleFlows.size() && canHandleFlows.get(0).getTaskOrder() > 0) {
            for (FlowBasic flowBasic : canHandleFlows) {
                json.put(flowBasic.getPrevStatus(), (Object)1);
            }
            String nextStatus = canHandleFlows.get(0).getNextStatus();
            ClassUtils.setFieldValue(bizEntity, this.getApprovalStatusJsonField(), JSON.toJSONString((Object)json));
            return nextStatus;
        }
        String nextStatus = this.findNextStatus(bizEntity, canHandleFlows.get(0).getNextStatus());
        ClassUtils.setFieldValue(bizEntity, this.getApprovalStatusField(), nextStatus);
        json = new JSONObject();
        if (nextStatus.contains(EX_AND)) {
            String[] steps;
            for (String step : steps = nextStatus.split(EX_AND)) {
                json.put(step, (Object)0);
            }
        } else if (nextStatus.contains(EX_OR)) {
            String[] steps;
            for (String step : steps = nextStatus.split(EX_OR_ESCAPE)) {
                json.put(step, (Object)0);
            }
        } else {
            json.put(nextStatus, (Object)0);
        }
        ClassUtils.setFieldValue(bizEntity, this.getApprovalStatusJsonField(), json.toJSONString());
        return nextStatus;
    }

    protected String findNextStatus(T bizEntity, String nextStatus) {
        if (nextStatus.startsWith("<%") && nextStatus.endsWith("%>")) {
            return RuleUtils.render(nextStatus, "vo", bizEntity);
        }
        return nextStatus;
    }

    protected abstract List<FlowBasic> authPermission(List<FlowBasic> var1, String var2);

    protected List<FlowBasic> findCurrentFlows(String approvalStatus, String action, Long roundId) {
        ArrayList<FlowBasic> flowBasicList = new ArrayList<FlowBasic>();
        ArrayList<String> waitingForHandledSteps = new ArrayList<String>();
        if (approvalStatus.contains(EX_AND)) {
            String[] steps;
            for (String step : steps = approvalStatus.split(EX_AND)) {
                FlowLog flowLog = (FlowLog)this.flowLogService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowLog::getRoundId, (Object)roundId)).eq(StringUtils.isNotBlank((CharSequence)action), FlowLog::getAction, (Object)action)).eq(FlowLog::getPrevStatus, (Object)step));
                if (flowLog != null) continue;
                waitingForHandledSteps.add(step);
            }
        } else if (approvalStatus.contains(EX_OR)) {
            String[] steps = approvalStatus.split(EX_OR_ESCAPE);
            waitingForHandledSteps.addAll(Arrays.asList(steps));
        } else {
            waitingForHandledSteps.add(approvalStatus);
        }
        if (CollectionUtils.isEmpty(waitingForHandledSteps)) {
            throw new FlowException(10008, "No waiting for handle steps.");
        }
        flowBasicList.addAll(this.flowBasicService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(StringUtils.isNotBlank((CharSequence)action), FlowBasic::getAction, new Object[]{action})).in(FlowBasic::getPrevStatus, waitingForHandledSteps)).eq(FlowBasic::getEntityName, (Object)this.getEntityName())).eq(FlowBasic::getFlowName, (Object)this.getFlowName())));
        return flowBasicList;
    }

    protected Long setFlowRoundId(T bizEntity, String user, boolean isSubmit) {
        if (isSubmit) {
            FlowRound flowRound = new FlowRound().setCreatedBy(user).setChangeRecord(null);
            this.flowRoundService.save(flowRound);
            ClassUtils.setFieldValue(bizEntity, this.getAroundIdField(), flowRound.getId());
            return flowRound.getId();
        }
        return ClassUtils.getLongValue(bizEntity, this.getAroundIdField());
    }

    protected void verifyParam(T bizEntity, String action, String comment, String user) {
        if (StringUtils.isBlank((CharSequence)this.getFlowName())) {
            throw new FlowException(10001, "Flow name can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            throw new FlowException(10002, "Flow entity name can not be empty.");
        }
        if (bizEntity == null) {
            throw new FlowException(10003, "Business entity can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)action)) {
            throw new FlowException(10004, "Handle action can not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new FlowException(10005, "Hander user can not be empty.");
        }
    }

    public void initApprovalStatus(T bizEntity) {
        FlowBasic flowBasic = (FlowBasic)this.flowBasicService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowBasic::getFlowName, (Object)this.getFlowName())).eq(FlowBasic::getTaskOrder, (Object)1)).eq(FlowBasic::getEntityName, (Object)this.getEntityName()));
        if (flowBasic == null) {
            throw new FlowException(10017, "You have not config the first task for current flow:" + this.getFlowName());
        }
        ClassUtils.setFieldValue(bizEntity, this.getApprovalStatusField(), flowBasic.getPrevStatus());
        JSONObject json = new JSONObject();
        json.put(flowBasic.getPrevStatus(), (Object)0);
        ClassUtils.setFieldValue(bizEntity, this.getApprovalStatusJsonField(), json.toJSONString());
    }

    public String getInitialStatus() {
        List flowBasics = this.flowBasicService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowBasic::getFlowName, (Object)this.getFlowName())).eq(FlowBasic::getEntityName, (Object)this.getEntityName())).eq(FlowBasic::getTaskOrder, (Object)1));
        if (CollectionUtils.isEmpty((Collection)flowBasics)) {
            throw new FlowException(10018, "Flow with task order 1 not found.");
        }
        if (flowBasics.size() > 1) {
            throw new FlowException(10019, "Only one flow with task order 1.");
        }
        return ((FlowBasic)flowBasics.get(0)).getPrevStatus();
    }

    public Set<String> getApprovedStatus() {
        List flowBasics = this.flowBasicService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowBasic::getFlowName, (Object)this.getFlowName())).eq(FlowBasic::getEntityName, (Object)this.getEntityName())).eq(FlowBasic::getLastTask, (Object)1));
        if (CollectionUtils.isEmpty((Collection)flowBasics)) {
            throw new FlowException(10020, "There are not flow with task order 100.");
        }
        HashSet<String> status = new HashSet<String>();
        for (FlowBasic flowBasic : flowBasics) {
            if (!StringUtils.isNotBlank((CharSequence)flowBasic.getNextStatus())) continue;
            status.add(flowBasic.getNextStatus());
        }
        return status;
    }

    public Set<String> getRejectedStatus() {
        List flowBasics = this.flowBasicService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowBasic::getFlowName, (Object)this.getFlowName())).eq(FlowBasic::getEntityName, (Object)this.getEntityName())).eq(FlowBasic::getLastTask, (Object)-1));
        if (CollectionUtils.isEmpty((Collection)flowBasics)) {
            throw new FlowException(10021, "There are not flow with task order -1.");
        }
        HashSet<String> status = new HashSet<String>();
        for (FlowBasic flowBasic : flowBasics) {
            if (!StringUtils.isNotBlank((CharSequence)flowBasic.getNextStatus())) continue;
            status.add(flowBasic.getNextStatus());
        }
        return status;
    }

    public boolean verifyHandleAccess(T bizEntity, String user) {
        Long roundId;
        if (bizEntity == null || StringUtils.isBlank((CharSequence)user)) {
            throw new FlowException(10022, "Business entity or user can not be empty when verify whether have handle access.");
        }
        String approvalStatus = ClassUtils.getStringValue(bizEntity, this.getApprovalStatusField());
        List<FlowBasic> currentSteps = this.findCurrentFlows(approvalStatus, null, roundId = ClassUtils.getLongValue(bizEntity, this.getAroundIdField()));
        if (CollectionUtils.isEmpty(currentSteps)) {
            return false;
        }
        List<FlowBasic> canHandleFlow = this.authPermission(currentSteps, user);
        return CollectionUtils.isNotEmpty(canHandleFlow);
    }

    public Set<String> getTodoStatus(TodoEnum todoEnum, Set<String> roles) {
        HashSet<String> status = new HashSet<String>();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(FlowBasic::getFlowName, (Object)this.getFlowName());
        if (todoEnum == TodoEnum.ONLY_PENDING_SUBMIT) {
            wrapper.in(FlowBasic::getTaskOrder, new Object[]{0, 1});
        } else if (todoEnum == TodoEnum.ONLY_PENDING_APPROVAL) {
            ((LambdaUpdateWrapper)wrapper.ne(FlowBasic::getTaskOrder, (Object)0)).ne(FlowBasic::getTaskOrder, (Object)1);
        }
        List flowBasics = this.flowBasicService.list((Wrapper)wrapper);
        block0: for (FlowBasic flowBasic : flowBasics) {
            if (StringUtils.isBlank((CharSequence)flowBasic.getHandleRoles())) continue;
            if (CollectionUtils.isEmpty(roles)) {
                status.add(flowBasic.getPrevStatus());
                continue;
            }
            JSONArray array = JSON.parseArray((String)flowBasic.getHandleRoles());
            for (int i = 0; i < array.size(); ++i) {
                if (!roles.contains(array.getString(i))) continue;
                status.add(flowBasic.getPrevStatus());
                continue block0;
            }
        }
        return status;
    }

    public String todoSql(Set<String> statusSet, String prefix) {
        if (CollectionUtils.isEmpty(statusSet)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int i = 0;
        for (String status : statusSet) {
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                sb.append(prefix);
            }
            sb.append(AbstractFlowHandler.camelCase2LineSeparation(this.getApprovalStatusJsonField())).append(" -> '$.\"").append(status).append("\"' = 0");
            if (i != statusSet.size() - 1) {
                sb.append(" or ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String camelCase2LineSeparation(String camelWord) {
        Matcher matcher = Pattern.compile("([A-Z][a-z])|([a-z][A-Z])").matcher(camelWord);
        StringBuffer word = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(word, matcher.group(0).replaceAll("(.$)", "_$1"));
        }
        matcher.appendTail(word);
        return word.toString().toUpperCase();
    }

    public FlowRootVo getFlowMetaInfoV1(T bizEntity) {
        if (bizEntity == null) {
            throw new FlowException(10023, "Business entity can not be empty when get flow meta info.");
        }
        FlowRootVo rootVo = new FlowRootVo();
        String approvalStatus = ClassUtils.getStringValue(bizEntity, this.getApprovalStatusField());
        JSONObject approvalStatusJson = JSONObject.parseObject((String)ClassUtils.getStringValue(bizEntity, this.getApprovalStatusJsonField()));
        approvalStatusJson.put("current_status", (Object)approvalStatus);
        rootVo.setApprovalStatus((Map<String, Object>)approvalStatusJson);
        List<FlowMetaVo> flowMetaVoList = this.flowBasicService.getFlowMetaInfoV1(this.getFlowName());
        rootVo.setFlowMetaVoList(flowMetaVoList);
        List historyLog = this.flowLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowLog::getFlowName, (Object)this.getFlowName())).eq(FlowLog::getEntityName, (Object)this.getEntityName())).eq(FlowLog::getRoundId, (Object)ClassUtils.getLongValue(bizEntity, this.getAroundIdField()))).eq(FlowLog::getOrderId, (Object)ClassUtils.getLongValue(bizEntity, this.getIdFiled()))).orderByAsc(FlowLog::getCreateTime));
        if (CollectionUtils.isNotEmpty((Collection)historyLog)) {
            ArrayList<FlowTraceVo> flowTraceVos = new ArrayList<FlowTraceVo>();
            for (FlowLog log : historyLog) {
                flowTraceVos.add(new FlowTraceVo().setPrevStatus(log.getPrevStatus()).setNextStatus(log.getNextStatus()).setAction(log.getAction()));
            }
            rootVo.setFlowTraceVoList(flowTraceVos);
        }
        return rootVo;
    }

    public FlowRootVo getFlowMetaInfoV2(T bizEntity) {
        if (bizEntity == null) {
            throw new FlowException(10023, "Business entity can not be empty when get flow meta info.");
        }
        FlowRootVo rootVo = new FlowRootVo();
        String approvalStatus = ClassUtils.getStringValue(bizEntity, this.getApprovalStatusField());
        JSONObject approvalStatusJson = JSONObject.parseObject((String)ClassUtils.getStringValue(bizEntity, this.getApprovalStatusJsonField()));
        approvalStatusJson.put("current_status", (Object)approvalStatus);
        rootVo.setApprovalStatus((Map<String, Object>)approvalStatusJson);
        List<FlowMetaVo> flowMetaVoList = this.flowBasicService.getFlowMetaInfoV2(this.getFlowName(), bizEntity);
        rootVo.setFlowMetaVoList(flowMetaVoList);
        List historyLog = this.flowLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowLog::getFlowName, (Object)this.getFlowName())).eq(FlowLog::getEntityName, (Object)this.getEntityName())).eq(FlowLog::getRoundId, (Object)ClassUtils.getLongValue(bizEntity, this.getAroundIdField()))).eq(FlowLog::getOrderId, (Object)ClassUtils.getLongValue(bizEntity, this.getIdFiled()))).orderByAsc(FlowLog::getCreateTime));
        if (CollectionUtils.isNotEmpty((Collection)historyLog)) {
            ArrayList<FlowTraceVo> flowTraceVos = new ArrayList<FlowTraceVo>();
            for (FlowLog log : historyLog) {
                flowTraceVos.add(new FlowTraceVo().setPrevStatus(log.getPrevStatus()).setNextStatus(log.getNextStatus()).setAction(log.getAction()));
            }
            rootVo.setFlowTraceVoList(flowTraceVos);
        }
        return rootVo;
    }

    public List<FlowLog> getHistoryFlowLog(T bizEntity, boolean currentAround) {
        return this.flowLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowLog::getFlowName, (Object)this.getFlowName())).eq(FlowLog::getEntityName, (Object)this.getEntityName())).eq(currentAround, FlowLog::getRoundId, (Object)ClassUtils.getLongValue(bizEntity, this.getAroundIdField()))).eq(FlowLog::getOrderId, (Object)ClassUtils.getLongValue(bizEntity, this.getIdFiled()))).orderByDesc(FlowLog::getCreateTime));
    }

    public String getIdFiled() {
        return "id";
    }

    public String getLastAuditMessageFiled() {
        return "lastAuditMessage";
    }

    public String getLastAuditByField() {
        return "lastAuditBy";
    }

    public String getLastAuditDateFiled() {
        return "lastAuditDate";
    }

    public String getLastSubmitMessageFiled() {
        return "lastSubmitMessage";
    }

    public String getLastSubmitByField() {
        return "lastSubmitBy";
    }

    public String getLastSubmitDateFiled() {
        return "lastSubmitDate";
    }

    public String getApprovalStatusField() {
        return "approvalStatus";
    }

    public String getApprovalStatusJsonField() {
        return "approvalStatusJson";
    }

    public String getAroundIdField() {
        return "aroundId";
    }

    protected abstract String getFlowName();

    protected abstract String getEntityName();
}

