/*
 * Decompiled with CFR 0.152.
 */
package wiki.capsule.flow.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import wiki.capsule.flow.entity.FlowBasic;
import wiki.capsule.flow.exception.FlowException;
import wiki.capsule.flow.mapper.FlowBasicMapper;
import wiki.capsule.flow.service.FlowBasicService;
import wiki.capsule.flow.utils.RuleUtils;
import wiki.capsule.flow.vo.FlowMetaVo;

@Service
public class FlowBasicServiceImpl
extends ServiceImpl<FlowBasicMapper, FlowBasic>
implements FlowBasicService {
    private static final Logger log = LoggerFactory.getLogger(FlowBasicServiceImpl.class);

    @Override
    public List<FlowMetaVo> getFlowMetaInfoV1(String flowName) {
        List flowBasics = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowBasic::getFlowName, (Object)flowName)).ge(FlowBasic::getTaskOrder, (Object)1));
        ArrayList<FlowMetaVo> flowMetaVoList = new ArrayList<FlowMetaVo>();
        for (FlowBasic flowBasic : flowBasics) {
            if (flowBasic.getNextStatus().startsWith("<%") && flowBasic.getNextStatus().endsWith("%>")) {
                if (StringUtils.isBlank((CharSequence)flowBasic.getNextStatusAlias())) {
                    throw new FlowException(10024, "Next status alias can not be empty.");
                }
                JSONArray array = JSON.parseArray((String)flowBasic.getNextStatusAlias());
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject item = array.getJSONObject(i);
                    FlowMetaVo metaVo = new FlowMetaVo().setAction(flowBasic.getAction()).setPrevStatus(flowBasic.getPrevStatus()).setNextStatus(item.getString("next_step")).setLabel(item.getString("label"));
                    flowMetaVoList.add(metaVo);
                }
                continue;
            }
            FlowMetaVo metaVo = new FlowMetaVo().setAction(flowBasic.getAction()).setNextStatus(flowBasic.getNextStatus()).setPrevStatus(flowBasic.getPrevStatus());
            flowMetaVoList.add(metaVo);
        }
        return flowMetaVoList;
    }

    @Override
    public List<FlowMetaVo> getFlowMetaInfoV2(String flowName, Object bizEntity) {
        List flowBasics = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlowBasic::getFlowName, (Object)flowName)).ge(FlowBasic::getTaskOrder, (Object)1));
        ArrayList<FlowMetaVo> flowMetaVoList = new ArrayList<FlowMetaVo>();
        HashMap<String, FlowBasic> flowBasicMap = new HashMap<String, FlowBasic>();
        FlowBasic firstFlow = null;
        for (FlowBasic flowBasic : flowBasics) {
            flowBasicMap.put(flowBasic.getPrevStatus(), flowBasic);
            if (flowBasic.getTaskOrder() != 1) continue;
            if (firstFlow != null) {
                throw new FlowException(10025, "Only one flow's task order can be 1.");
            }
            firstFlow = flowBasic;
        }
        if (firstFlow == null) {
            throw new FlowException(10025, "There must be one flow's task order is 1.");
        }
        FlowBasic flowBasic = firstFlow;
        while (flowBasic != null) {
            FlowMetaVo metaVo;
            String nextStatus;
            if (flowBasic.getNextStatus().startsWith("<%") && flowBasic.getNextStatus().endsWith("%>")) {
                nextStatus = RuleUtils.render(flowBasic.getNextStatus(), "vo", bizEntity);
                metaVo = new FlowMetaVo().setPrevStatus(flowBasic.getPrevStatus()).setNextStatus(nextStatus).setAction(flowBasic.getAction());
                if (StringUtils.isNotBlank((CharSequence)flowBasic.getNextStatusAlias())) {
                    JSONArray array = JSON.parseArray((String)flowBasic.getNextStatusAlias());
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject item = array.getJSONObject(i);
                        if (!nextStatus.equalsIgnoreCase(item.getString("next_status"))) continue;
                        metaVo.setLabel(item.getString("label"));
                        break;
                    }
                }
                flowMetaVoList.add(metaVo);
            } else {
                metaVo = new FlowMetaVo().setPrevStatus(flowBasic.getPrevStatus()).setNextStatus(flowBasic.getNextStatus()).setAction(flowBasic.getAction());
                flowMetaVoList.add(metaVo);
                nextStatus = flowBasic.getNextStatus();
            }
            flowBasic = (FlowBasic)flowBasicMap.get(nextStatus);
        }
        return flowMetaVoList;
    }
}

