/*
 * Decompiled with CFR 0.152.
 */
package wiki.capsule.flow.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiki.capsule.flow.exception.FlowException;

public class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static void setFieldValue(Object target, String fieldName, Object value) {
        if (target == null || StringUtils.isBlank((CharSequence)fieldName)) {
            throw new FlowException(10012, "Target object or field name can not be empty when set field value.");
        }
        try {
            FieldUtils.writeField((Object)target, (String)fieldName, (Object)value, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new FlowException(10011, "Field name " + fieldName + "  may not exist in object " + target.getClass().getCanonicalName());
        }
    }

    public static Long getLongValue(Object target, String fieldName) {
        if (target == null || StringUtils.isBlank((CharSequence)fieldName)) {
            throw new FlowException(10013, "Target object or field name can not be empty when get [Long] filed value.");
        }
        try {
            Object longValue = FieldUtils.readField((Object)target, (String)fieldName, (boolean)true);
            if (longValue == null) {
                return null;
            }
            try {
                return Long.parseLong(longValue.toString());
            }
            catch (NumberFormatException e) {
                throw new FlowException(10015, "Value " + longValue + " can not be parsed to Long type.");
            }
        }
        catch (IllegalAccessException e) {
            throw new FlowException(10011, "Field name " + fieldName + "  may not exist in object " + target.getClass().getCanonicalName());
        }
    }

    public static String getStringValue(Object target, String fieldName) {
        if (target == null || StringUtils.isBlank((CharSequence)fieldName)) {
            throw new FlowException(10014, "Target object or field name can not be empty when get [String] filed value.");
        }
        try {
            Object longValue = FieldUtils.readField((Object)target, (String)fieldName, (boolean)true);
            if (longValue == null) {
                return null;
            }
            return String.valueOf(longValue);
        }
        catch (IllegalAccessException e) {
            throw new FlowException(10011, "Field name " + fieldName + "  may not exist in object " + target.getClass().getCanonicalName());
        }
    }
}

