package wiki.xsx.core.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import wiki.xsx.core.consul.ConsulRetryRegistry;

/**
 * consul重试自动配置
 * @author xsx
 * @date 2019/10/30
 * @since 1.8
 */
@Configuration
@ConditionalOnClass({
        ConsulDiscoveryClient.class,
        ConsulAutoRegistration.class,
        ConsulServiceRegistry.class
})
@Import({ConsulRetryProperties.class})
public class ConsulRetryAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean({ConsulRetryRegistry.class})
    public ConsulRetryRegistry consulRetryRegistry(
            ConsulAutoRegistration consulAutoRegistration,
            ConsulServiceRegistry consulServiceRegistry,
            DiscoveryClient discoveryClient,
            ConsulRetryProperties properties
    ) {
        return new ConsulRetryRegistry(
                consulAutoRegistration,
                consulServiceRegistry,
                discoveryClient,
                properties
        );
    }
}
