package wiki.xsx.core.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * consul重试配置
 * @author xsx
 * @date 2019/10/31
 * @since 1.8
 */
@Data
@Configuration
@ConfigurationProperties("spring.cloud.consul.retry")
public class ConsulRetryProperties {
    /**
     * 监测间隔（单位：ms）
     */
    private long initialInterval = 10000L;
    /**
     * 间隔因子（备用）
     */
    private double multiplier = 1.1D;
    /**
     * 最大间隔（备用）
     */
    private long maxInterval = 20000L;
    /**
     * 重试次数（备用）
     */
    private int maxAttempts = 6;
}
