/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.config.lettuce;

import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.ArrayOutput;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.ByteArrayOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.DateOutput;
import io.lettuce.core.output.DoubleOutput;
import io.lettuce.core.output.GeoCoordinatesListOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.KeyScanOutput;
import io.lettuce.core.output.KeyValueOutput;
import io.lettuce.core.output.KeyValueScoredValueOutput;
import io.lettuce.core.output.MapOutput;
import io.lettuce.core.output.MapScanOutput;
import io.lettuce.core.output.MultiOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.ScoredValueOutput;
import io.lettuce.core.output.ScoredValueScanOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.StreamMessageListOutput;
import io.lettuce.core.output.StreamReadOutput;
import io.lettuce.core.output.StringValueListOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.output.ValueScanOutput;
import io.lettuce.core.output.ValueSetOutput;
import io.lettuce.core.protocol.CommandType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LettuceTypeHint {
    private static final Map<CommandType, Class<? extends CommandOutput>> COMMAND_OUTPUT_TYPE_MAPPING = new HashMap<CommandType, Class<? extends CommandOutput>>();
    private static final Map<Class<?>, Constructor<CommandOutput>> CONSTRUCTORS = new ConcurrentHashMap();

    public static CommandOutput getTypeHint(String command, String key) {
        Class<? extends CommandOutput> type = COMMAND_OUTPUT_TYPE_MAPPING.get(CommandType.valueOf((String)command));
        if (type.isAssignableFrom(StreamMessageListOutput.class)) {
            return new StreamMessageListOutput((RedisCodec)ByteArrayCodec.INSTANCE, (Object)key);
        }
        return LettuceTypeHint.getTypeHint(type, (CommandOutput)new ByteArrayOutput((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    private static CommandOutput getTypeHint(Class<? extends CommandOutput> type, CommandOutput defaultType) {
        if (type == null) {
            return defaultType;
        }
        CommandOutput outputType = LettuceTypeHint.instanciateCommandOutput(type);
        return outputType != null ? outputType : defaultType;
    }

    private static CommandOutput<?, ?, ?> instanciateCommandOutput(Class<? extends CommandOutput> type) {
        Assert.notNull(type, (String)"Cannot create instance for 'null' type.");
        Constructor constructor = CONSTRUCTORS.get(type);
        if (constructor == null) {
            constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{RedisCodec.class});
            CONSTRUCTORS.put(type, constructor);
        }
        return (CommandOutput)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{ByteArrayCodec.INSTANCE});
    }

    static {
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITCOUNT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITOP, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITPOS, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DBSIZE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DECR, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DECRBY, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DEL, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETBIT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HDEL, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HINCRBY, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HLEN, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCR, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCRBY, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LINSERT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LLEN, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPUSH, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPUSHX, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LREM, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PTTL, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PUBLISH, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPUSH, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPUSHX, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SADD, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SCARD, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SDIFFSTORE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETBIT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETRANGE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SINTERSTORE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SREM, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SUNIONSTORE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.STRLEN, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TTL, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZADD, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZCOUNT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZINTERSTORE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANK, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREM, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYRANK, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYSCORE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANK, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZUNIONSTORE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PFCOUNT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PFMERGE, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PFADD, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XACK, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XDEL, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XLEN, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XTRIM, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TOUCH, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.UNLINK, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.APPEND, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSTRLEN, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZCARD, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZLEXCOUNT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYLEX, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GEOADD, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GEORADIUS, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GEORADIUSBYMEMBER, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.WAIT, IntegerOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HINCRBYFLOAT, DoubleOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCRBYFLOAT, DoubleOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZINCRBY, DoubleOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZSCORE, DoubleOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GEODIST, DoubleOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZPOPMIN, ScoredValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZPOPMAX, ScoredValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.CONFIG, MapOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HGETALL, MapOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HKEYS, KeyListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.KEYS, KeyListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PUBSUB, KeyListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BRPOP, KeyValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BLPOP, KeyValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BRPOPLPUSH, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ECHO, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GET, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETRANGE, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETSET, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HGET, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LINDEX, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPOP, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RANDOMKEY, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RENAME, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPOP, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPOPLPUSH, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SPOP, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SRANDMEMBER, ValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.AUTH, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PING, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.READONLY, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.READWRITE, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SWAPDB, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BGREWRITEAOF, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BGSAVE, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.CLIENT, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DEBUG, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DISCARD, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.FLUSHALL, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.FLUSHDB, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HMSET, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INFO, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LSET, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LTRIM, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MIGRATE, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MSET, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.QUIT, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RESTORE, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SAVE, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SELECT, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SET, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETEX, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SHUTDOWN, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SLAVEOF, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SYNC, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TYPE, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.WATCH, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.UNWATCH, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XADD, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XGROUP, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.OBJECT, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PSETEX, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ASKING, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.CLUSTER, StatusOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HMGET, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MGET, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HVALS, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LRANGE, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SORT, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGE, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGEBYSCORE, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGE, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGEBYSCORE, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGEBYLEX, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGEBYLEX, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TIME, ValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GEOHASH, StringValueListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXISTS, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXPIRE, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXPIREAT, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HEXISTS, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSET, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSETNX, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MOVE, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MSETNX, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PERSIST, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PEXPIRE, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PEXPIREAT, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RENAMENX, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETNX, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SISMEMBER, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SMOVE, BooleanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXEC, MultiOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MULTI, MultiOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LASTSAVE, DateOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GEOPOS, GeoCoordinatesListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SDIFF, ValueSetOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SINTER, ValueSetOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SMEMBERS, ValueSetOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SUNION, ValueSetOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BZPOPMIN, KeyValueScoredValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BZPOPMAX, KeyValueScoredValueOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XCLAIM, StreamMessageListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XREVRANGE, StreamMessageListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XRANGE, StreamMessageListOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XPENDING, NestedMultiOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SLOWLOG, NestedMultiOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XREAD, StreamReadOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.XREADGROUP, StreamReadOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.COMMAND, ArrayOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ROLE, ArrayOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DUMP, ArrayOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITFIELD, ArrayOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SCAN, KeyScanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSCAN, MapScanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SSCAN, ValueScanOutput.class);
        COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZSCAN, ScoredValueScanOutput.class);
    }
}

