/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.core.RedisTemplate;
import wiki.xsx.core.config.lettuce.LettuceTypeHint;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class CustomCommandHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;

    CustomCommandHandler(Integer dbIndex) {
        this.redisTemplate = HandlerManager.createRedisTemplate(dbIndex);
    }

    CustomCommandHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
    }

    public Object execute(String command, byte[] ... args) {
        return this.executeCommand(command, args);
    }

    public byte[] serializeAsObj(Object value) {
        return ConvertUtil.toBytes(this.redisTemplate.getValueSerializer(), value);
    }

    public byte[] serialize(String value) {
        return ConvertUtil.toBytes(this.redisTemplate.getKeySerializer(), value);
    }

    public <T> T deserializeAsObj(byte[] bytes) {
        return (T)ConvertUtil.toJavaType(this.redisTemplate.getValueSerializer().deserialize(bytes), Object.class);
    }

    public <T> T deserializeAsObj(Class<T> type, byte[] bytes) {
        return (T)ConvertUtil.toJavaType(this.redisTemplate.getValueSerializer().deserialize(bytes), type);
    }

    public <T> T deserialize(byte[] bytes) {
        return (T)this.redisTemplate.getKeySerializer().deserialize(bytes);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    private Object executeCommand(String command, byte[] ... args) {
        RedisConnection connection = this.redisTemplate.getRequiredConnectionFactory().getConnection();
        if (connection instanceof LettuceConnection) {
            return this.executeCommandByLettuce(connection, command, args);
        }
        return connection.execute(command, args);
    }

    private Object executeCommandByLettuce(RedisConnection connection, String command, byte[] ... args) {
        if (args.length > 0) {
            return ((LettuceConnection)connection).execute(command, LettuceTypeHint.getTypeHint(command, (String)this.deserialize(args[0])), args);
        }
        return ((LettuceConnection)connection).execute(command, LettuceTypeHint.getTypeHint(command, null), args);
    }
}

